/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.marketcetera.util.file.SmartLinksDirectoryWalker;
import org.marketcetera.util.misc.OperatingSystem;
import org.marketcetera.util.test.CollectionAssert;
import org.marketcetera.util.test.TestCaseBase;

public class SmartLinksDirectoryWalkerTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "directory_walker" + File.separator;
    private static final String TEST_DIR_WIN32 = "win32";
    private static final String TEST_DIR_UNIX = "unix";
    private static final String TEST_ROOT_WIN32 = TEST_ROOT + "win32" + File.separator;
    private static final String TEST_ROOT_UNIX = TEST_ROOT + "unix" + File.separator;
    private static final String TEST_NONEXISTENT_FILE = TEST_ROOT + "nonexistent";
    private static final String TEST_FILE = "a.txt";
    private static final String TEST_LINK_NAME = "e";
    private static final String TEST_LINK_PATH = "a" + File.separator + "e";
    private static final String TEST_LINK_CONTENTS = "e.txt";
    private static final String[] TEST_FILE_LIST = new String[]{"a.txt", "b.txt", "c.txt", "d.txt", "e.txt"};
    private static final String[] TEST_DIR_LIST = new String[]{"a", "b", "c", "d"};

    @Test
    public void singleFile() throws Exception {
        ListWalker walker = new ListWalker(false);
        walker.apply(TEST_ROOT + TEST_FILE);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
        Vector results = new Vector();
        walker = new ListWalker(false);
        walker.apply(TEST_ROOT + TEST_FILE, results);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
        walker = new ListWalker(true);
        walker.apply(TEST_ROOT + TEST_FILE);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
        results = new Vector();
        walker = new ListWalker(true);
        walker.apply(TEST_ROOT + TEST_FILE, results);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_FILE}, (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
    }

    @Test
    public void singleLink() throws Exception {
        Assume.assumeTrue((boolean)OperatingSystem.LOCAL.isUnix());
        ListWalker walker = new ListWalker(false);
        walker.apply(TEST_ROOT_UNIX + TEST_LINK_PATH);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
        Vector results = new Vector();
        walker = new ListWalker(false);
        walker.apply(TEST_ROOT_UNIX + TEST_LINK_PATH, results);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME}, (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)0L, (long)walker.getMaxDepth());
        walker = new ListWalker(true);
        walker.apply(TEST_ROOT_UNIX + TEST_LINK_PATH);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_CONTENTS}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME}, (Object[])walker.getDirectories());
        Assert.assertEquals((long)1L, (long)walker.getMaxDepth());
        results = new Vector();
        walker = new ListWalker(true);
        walker.apply(TEST_ROOT_UNIX + TEST_LINK_PATH, results);
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_CONTENTS}, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME}, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])new String[]{TEST_LINK_NAME, TEST_LINK_CONTENTS}, (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)1L, (long)walker.getMaxDepth());
    }

    @Test
    public void nonexistentFiles() throws Exception {
        ListWalker walker = new ListWalker(false);
        walker.apply(TEST_NONEXISTENT_FILE);
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        Assert.assertEquals((long)-1L, (long)walker.getMaxDepth());
        Vector results = new Vector();
        walker = new ListWalker(true);
        walker.apply(TEST_NONEXISTENT_FILE, results);
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)-1L, (long)walker.getMaxDepth());
    }

    @Test
    public void walk() throws Exception {
        String root;
        String dir;
        Object[] files = TEST_FILE_LIST;
        if (OperatingSystem.LOCAL.isUnix()) {
            dir = TEST_DIR_UNIX;
            root = TEST_ROOT_UNIX;
            files = (String[])ArrayUtils.add((Object[])files, (Object)TEST_LINK_NAME);
        } else if (OperatingSystem.LOCAL.isWin32()) {
            dir = TEST_DIR_WIN32;
            root = TEST_ROOT_WIN32;
        } else {
            throw new AssertionError((Object)"Unknown platform");
        }
        Object[] dirs = (String[])ArrayUtils.add((Object[])TEST_DIR_LIST, (Object)dir);
        ListWalker walker = new ListWalker(false);
        walker.apply(root);
        CollectionAssert.assertArrayPermutation((Object[])files, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])dirs, (Object[])walker.getDirectories());
        Assert.assertEquals((long)3L, (long)walker.getMaxDepth());
        Vector results = new Vector();
        walker = new ListWalker(false);
        walker.apply(root, results);
        CollectionAssert.assertArrayPermutation((Object[])files, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])dirs, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.addAll((Object[])files, (Object[])dirs), (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)3L, (long)walker.getMaxDepth());
        files = TEST_FILE_LIST;
        dirs = (String[])ArrayUtils.add((Object[])TEST_DIR_LIST, (Object)dir);
        if (OperatingSystem.LOCAL.isUnix()) {
            files = (String[])ArrayUtils.add((Object[])files, (Object)TEST_LINK_CONTENTS);
            dirs = (String[])ArrayUtils.add((Object[])dirs, (Object)TEST_LINK_NAME);
        }
        walker = new ListWalker(true);
        walker.apply(root);
        CollectionAssert.assertArrayPermutation((Object[])files, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])dirs, (Object[])walker.getDirectories());
        Assert.assertEquals((long)3L, (long)walker.getMaxDepth());
        results = new Vector();
        walker = new ListWalker(true);
        walker.apply(root, results);
        CollectionAssert.assertArrayPermutation((Object[])files, (Object[])walker.getFiles());
        CollectionAssert.assertArrayPermutation((Object[])dirs, (Object[])walker.getDirectories());
        CollectionAssert.assertArrayPermutation((Object[])ArrayUtils.addAll((Object[])files, (Object[])dirs), (Object[])results.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        Assert.assertEquals((long)3L, (long)walker.getMaxDepth());
    }

    public static final class ListWalker
    extends SmartLinksDirectoryWalker {
        private Vector<String> mFiles = new Vector();
        private Vector<String> mDirectories = new Vector();
        private int mMaxDepth = -1;

        public ListWalker(boolean followLinks) {
            super(followLinks);
        }

        public String[] getFiles() {
            return this.mFiles.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }

        public String[] getDirectories() {
            return this.mDirectories.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        }

        public int getMaxDepth() {
            return this.mMaxDepth;
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
            return super.handleDirectory(directory, depth, results) && !".svn".equals(directory.getName());
        }

        protected void handleDirectoryStart(File directory, int depth, Collection results) {
            this.mDirectories.add(directory.getName());
            if (results != null) {
                results.add(directory.getName());
            }
            if (depth > this.mMaxDepth) {
                this.mMaxDepth = depth;
            }
        }

        protected void handleFile(File file, int depth, Collection results) {
            this.mFiles.add(file.getName());
            if (results != null) {
                results.add(file.getName());
            }
            if (depth > this.mMaxDepth) {
                this.mMaxDepth = depth;
            }
        }
    }
}

