/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.log.LogUtils;
import org.marketcetera.util.log.TestMessages;

public class LogUtilsTest {
    @Test
    public void listText() {
        Assert.assertEquals((Object)"()", (Object)LogUtils.getListText((Object[])new Object[0]));
        Assert.assertEquals((Object)"([null])", (Object)LogUtils.getListText((Object[])null));
        Assert.assertEquals((Object)"([null])", (Object)LogUtils.getListText((Object[])new Object[]{null}));
        Assert.assertEquals((Object)"('a')", (Object)LogUtils.getListText((Object[])new Object[]{Character.valueOf('a')}));
        Assert.assertEquals((Object)"('a','b')", (Object)LogUtils.getListText((Object[])new Object[]{Character.valueOf('a'), "b"}));
        Assert.assertEquals((Object)"('a',[null])", (Object)LogUtils.getListText((Object[])new Object[]{Character.valueOf('a'), null}));
    }

    @Test
    public void simpleMessage() {
        I18NMessageProvider provider = new I18NMessageProvider("nonexistent_prv");
        Assert.assertEquals((Object)"provider 'nonexistent_prv'; id 'log'; entry 'msg'; parameters ()", (Object)LogUtils.getSimpleMessage((I18NMessageProvider)provider, (I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[0]));
        Assert.assertEquals((Object)"provider 'nonexistent_prv'; id 'log'; entry 'msg'; parameters ([null])", (Object)LogUtils.getSimpleMessage((I18NMessageProvider)provider, (I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[]{null}));
        Assert.assertEquals((Object)"provider 'nonexistent_prv'; id 'log'; entry 'msg'; parameters ([null])", (Object)LogUtils.getSimpleMessage((I18NMessageProvider)provider, (I18NMessage)TestMessages.LOG_MSG, (Object[])null));
        Assert.assertEquals((Object)"provider 'nonexistent_prv'; id 'log'; entry 'msg'; parameters ('a',[null])", (Object)LogUtils.getSimpleMessage((I18NMessageProvider)provider, (I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[]{"a", null}));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ()", (Object)LogUtils.getSimpleMessage((I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[0]));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ([null])", (Object)LogUtils.getSimpleMessage((I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[]{null}));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ([null])", (Object)LogUtils.getSimpleMessage((I18NMessage)TestMessages.LOG_MSG, (Object[])null));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ('a',[null])", (Object)LogUtils.getSimpleMessage((I18NMessage)TestMessages.LOG_MSG, (Object[])new Object[]{"a", null}));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ([null])", (Object)LogUtils.getSimpleMessage((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.LOG_MSG, (Serializable)null)));
        Assert.assertEquals((Object)"provider 'util_log_test'; id 'log'; entry 'msg'; parameters ('a')", (Object)LogUtils.getSimpleMessage((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.LOG_MSG, (Serializable)((Object)"a"))));
    }
}

