/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.ActiveLocale;
import org.marketcetera.util.log.I18NLoggerProxy;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessageProvider;
import org.marketcetera.util.log.TestMessages;
import org.marketcetera.util.test.EqualityAssert;
import org.marketcetera.util.test.SerializableAssert;
import org.marketcetera.util.test.TestCaseBase;

public class TI18NLoggerProxyTest
extends TestCaseBase {
    private static final String TEST_CATEGORY = "TestCategory";
    private static final String TEST_MSG_EN = "Test here (expected): 'a'";
    private static final String TEST_MSG_FR = "Test voil\u00e0 (attendu): 'a'";
    private static final String TEST_MSG_EN_NULL = "Test here (expected): 'null'";
    private static final String TEST_MSG_FR_NULL = "Test voil\u00e0 (attendu): 'null'";
    private static final String TEST_MSG_EN_NOSUB = "Test here (expected): ''{0}''";
    private static final String TEST_MSG_FR_NOSUB = "Test voil\u00e0 (attendu): ''{0}''";
    private static final Exception TEST_THROWABLE = new IllegalArgumentException("Test exception (expected)");

    private void messageCheck(Locale locale, String msg, String msgNull, String msgNoSub) {
        ActiveLocale.setProcessLocale((Locale)locale);
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.error((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.warn((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.info((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.debug((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE);
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{"a"});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, (Object[])null);
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (Throwable)TEST_THROWABLE, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
        TestMessages.LOGGER.trace((Object)TEST_CATEGORY, (I18NMessage)TestMessages.LOG_MSG, new Object[]{null});
    }

    @Test
    public void providerIsValid() {
        Assert.assertEquals((Object)TestMessages.PROVIDER, (Object)TestMessages.LOGGER.getMessageProvider());
    }

    @Test
    public void equality() {
        EqualityAssert.assertEquality((Object)new I18NLoggerProxy(new I18NMessageProvider("a")), (Object)new I18NLoggerProxy(new I18NMessageProvider("a")), (Object[])new Object[]{new I18NLoggerProxy(new I18NMessageProvider("b"))});
        SerializableAssert.assertSerializable((Serializable)TestMessages.LOGGER);
    }

    @Test
    public void messages() {
        this.messageCheck(Locale.ROOT, TEST_MSG_EN, TEST_MSG_EN_NULL, TEST_MSG_EN_NOSUB);
        this.messageCheck(Locale.FRENCH, TEST_MSG_FR, TEST_MSG_FR_NULL, TEST_MSG_FR_NOSUB);
    }
}

