/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.log;

import java.io.Serializable;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.I18NMessage1P;
import org.marketcetera.util.log.I18NMessageTestBase;
import org.marketcetera.util.log.TestMessages;

public class TI18NMessage1PTest
extends I18NMessageTestBase {
    private static final String TEST_MSG_EN = "P1 msg (expected) en 1";
    private static final String TEST_TTL_EN = "P1 ttl (expected) en 1";
    private static final String TEST_MSG_FR = "P1 msg (expected) fr 1";
    private static final String TEST_TTL_FR = "P1 ttl (expected) fr 1";

    private static void castOverride(I18NMessage1P m) {
    }

    @Test
    public void basic() {
        TI18NMessage1PTest.unboundTests(1, (I18NMessage)new I18NMessage1P(TestMessages.LOGGER, "base", "ttl"), (I18NMessage)new I18NMessage1P(TestMessages.LOGGER, "base", "ttl"), new I18NMessage[]{new I18NMessage1P(TEST_LOGGER_D, "base", "ttl"), new I18NMessage1P(TestMessages.LOGGER, "baseD", "ttl"), new I18NMessage1P(TestMessages.LOGGER, "base", "ttlD"), new I18NMessage0P(TestMessages.LOGGER, "base", "ttl")}, (I18NMessage)new I18NMessage1P(TestMessages.LOGGER, "base"));
    }

    @Test
    public void messageProvider() {
        Assert.assertEquals((Object)TEST_MSG_EN, (Object)TestMessages.P1_MSG.getText((Object)"1"));
        Assert.assertEquals((Object)TEST_TTL_EN, (Object)TestMessages.P1_TTL.getText((Object)"1"));
        Assert.assertEquals((Object)TEST_MSG_FR, (Object)TestMessages.P1_MSG.getText(Locale.FRENCH, (Object)"1"));
        Assert.assertEquals((Object)TEST_TTL_FR, (Object)TestMessages.P1_TTL.getText(Locale.FRENCH, (Object)"1"));
    }

    @Test
    public void loggerProxy() {
        TestMessages.P1_MSG.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_MSG.error((Object)"TestCategory", (Object)"1");
        TestMessages.P1_TTL.error((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_TTL.error((Object)"TestCategory", (Object)"1");
        TestMessages.P1_MSG.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_MSG.warn((Object)"TestCategory", (Object)"1");
        TestMessages.P1_TTL.warn((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_TTL.warn((Object)"TestCategory", (Object)"1");
        TestMessages.P1_MSG.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_MSG.info((Object)"TestCategory", (Object)"1");
        TestMessages.P1_TTL.info((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_TTL.info((Object)"TestCategory", (Object)"1");
        TestMessages.P1_MSG.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_MSG.debug((Object)"TestCategory", (Object)"1");
        TestMessages.P1_TTL.debug((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_TTL.debug((Object)"TestCategory", (Object)"1");
        TestMessages.P1_MSG.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_MSG.trace((Object)"TestCategory", (Object)"1");
        TestMessages.P1_TTL.trace((Object)"TestCategory", (Throwable)TEST_THROWABLE, (Object)"1");
        TestMessages.P1_TTL.trace((Object)"TestCategory", (Object)"1");
    }

    @Test
    public void bound() {
        Serializable[] params = new Serializable[]{"1"};
        I18NBoundMessage1P m = new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"1"));
        this.boundTests((I18NBoundMessage)m, (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"1")), new I18NBoundMessage[]{new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"2")), new I18NBoundMessage1P(TestMessages.P1_TTL, (Serializable)((Object)"1")), TestMessages.P0_MSG}, params, (I18NMessage)TestMessages.P1_MSG, TEST_MSG_EN, TEST_MSG_FR);
        TI18NMessage1PTest.castOverride((I18NMessage1P)m.getMessage());
        this.boundTests((I18NBoundMessage)new I18NBoundMessage1P(TestMessages.P1_TTL, (Serializable)((Object)"1")), (I18NBoundMessage)new I18NBoundMessage1P(TestMessages.P1_TTL, (Serializable)((Object)"1")), new I18NBoundMessage[]{new I18NBoundMessage1P(TestMessages.P1_TTL, (Serializable)((Object)"2")), new I18NBoundMessage1P(TestMessages.P1_MSG, (Serializable)((Object)"1")), TestMessages.P0_TTL}, params, (I18NMessage)TestMessages.P1_TTL, TEST_TTL_EN, TEST_TTL_FR);
        Assert.assertEquals((Object)"1", (Object)m.getParam1());
    }
}

