/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.StringUtils;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;

public class StringUtilsTest
extends TestCaseBase {
    private static void single(String s, int[] ucps) {
        Assert.assertEquals((long)ucps.length, (long)StringUtils.lengthUCP((String)s));
        Assert.assertEquals((Object)s, (Object)StringUtils.fromUCP((int[])ucps));
        Assert.assertArrayEquals((int[])ucps, (int[])StringUtils.toUCPArray((String)s));
        String c = StringUtils.fromUCP((int)ucps[0]);
        Assert.assertEquals((long)1L, (long)StringUtils.lengthUCP((String)c));
        Assert.assertEquals((long)ucps[0], (long)c.codePointAt(0));
    }

    @Test
    public void all() {
        Assert.assertNull((Object)StringUtils.toUCPArray(null));
        StringUtilsTest.single(" ", UnicodeData.SPACE_UCPS);
        StringUtilsTest.single("Hello", UnicodeData.HELLO_EN_UCPS);
        StringUtilsTest.single("Spr\u00e5k", UnicodeData.LANGUAGE_NO_UCPS);
        StringUtilsTest.single("\u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5", UnicodeData.HELLO_GR_UCPS);
        StringUtilsTest.single("\u0645\u0646\u0632\u0644", UnicodeData.HOUSE_AR_UCPS);
        StringUtilsTest.single("\u3055\u3088\u3046\u306a\u3089", UnicodeData.GOODBYE_JA_UCPS);
        StringUtilsTest.single("\ud800\udc88 \ud800\udc89", UnicodeData.GOATS_LNB_UCPS);
        StringUtilsTest.single("\ud834\udd1e", UnicodeData.G_CLEF_MSC_UCPS);
    }

    @Test
    public void toUCPArrayStr() {
        Assert.assertNull((Object)StringUtils.toUCPArrayStr(null));
        Assert.assertEquals((Object)"U+10088 U+20 U+10089", (Object)StringUtils.toUCPArrayStr((String)"\ud800\udc88 \ud800\udc89"));
        Assert.assertEquals((Object)"U+1D11E", (Object)StringUtils.toUCPArrayStr((String)"\ud834\udd1e"));
        Assert.assertEquals((Object)"U+3055 U+3088 U+3046 U+306A U+3089", (Object)StringUtils.toUCPArrayStr((String)"\u3055\u3088\u3046\u306a\u3089"));
    }

    @Test
    public void isValid() {
        Assert.assertTrue((boolean)StringUtils.isValid((int)UnicodeData.G_CLEF_MSC_UCPS[0]));
        Assert.assertFalse((boolean)StringUtils.isValid((int)0x10000000));
        Assert.assertFalse((boolean)StringUtils.isValid((int)55297));
    }
}

