/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.misc;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.misc.UCPFilter;
import org.marketcetera.util.misc.UCPFilterInfo;
import org.marketcetera.util.test.TestCaseBase;

public class UCPFilterInfoTest
extends TestCaseBase {
    private static final UCPFilter FILTER = new UCPFilter(){

        public boolean isAcceptable(int ucp) {
            return ucp >= 256 && ucp <= 258;
        }
    };

    @Test
    public void all() {
        UCPFilterInfo info = UCPFilterInfo.getInfo((UCPFilter)FILTER);
        Assert.assertSame((Object)info, (Object)UCPFilterInfo.getInfo((UCPFilter)FILTER));
        Assert.assertArrayEquals((int[])new int[]{256, 257, 258}, (int[])info.getUCPs());
        info = UCPFilterInfo.getInfo((UCPFilter)UCPFilter.DIGIT);
        Assert.assertSame((Object)info, (Object)UCPFilterInfo.getInfo((UCPFilter)UCPFilter.DIGIT));
        Assert.assertTrue((Arrays.binarySearch(info.getUCPs(), 49) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((Arrays.binarySearch(info.getUCPs(), 50) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((Arrays.binarySearch(info.getUCPs(), 97) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)UCPFilterInfo.getInfo((UCPFilter)UCPFilter.ALNUM).getUCPs().length, (long)(UCPFilterInfo.getInfo((UCPFilter)UCPFilter.DIGIT).getUCPs().length + UCPFilterInfo.getInfo((UCPFilter)UCPFilter.LETTER).getUCPs().length));
    }
}

