/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.spring;

import java.io.File;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.spring.SpringUtils;
import org.marketcetera.util.test.TestCaseBase;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class SpringUtilsTest
extends TestCaseBase {
    private static final String TEST_ROOT = DIR_ROOT + File.separator + "spring" + File.separator;
    private static final String TEST_NAME_BEAN = "testNameBean";
    private static final String TEST_VALUE = "testValue";
    private static final String TEST_NAME_PROP = "testNameProp";
    private static final String TEST_NAME_PROP_BLANK = "testNamePropBlank";
    private static final String TEST_VALUE_PROP = "testValueProp";
    private static final String TEST_VALUE_PROP_OVERRIDE = "testValuePropOverride";
    private static final String TEST_CONFIGURER_BEAN = "testConfigurer";
    private static final String TEST_SPRING_FILE = TEST_ROOT + "spring.xml";
    private static final String TEST_PROPERTIES_FILE_BEAN = "propertiesFile";
    private static final String TEST_PROPERTIES_FILES_BEAN = "propertiesFiles";

    @Test
    public void stringBean() {
        GenericApplicationContext context = new GenericApplicationContext();
        SpringUtils.addStringBean((BeanDefinitionRegistry)context, (String)TEST_NAME_BEAN, (String)TEST_VALUE);
        context.refresh();
        Assert.assertEquals((Object)TEST_VALUE, (Object)context.getBean(TEST_NAME_BEAN));
    }

    @Test
    public void propertiesConfigurerStringSet() {
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(TEST_SPRING_FILE));
        SpringUtils.addPropertiesConfigurer((BeanDefinitionRegistry)context, (String)TEST_CONFIGURER_BEAN, (String)TEST_PROPERTIES_FILE_BEAN);
        SpringUtils.addStringBean((BeanDefinitionRegistry)context, (String)TEST_NAME_BEAN, (String)"${testNameProp}");
        context.refresh();
        Assert.assertEquals((Object)TEST_VALUE_PROP, (Object)context.getBean(TEST_NAME_BEAN));
    }

    @Test
    public void propertiesConfigurerStringUnset() {
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(TEST_SPRING_FILE));
        SpringUtils.addPropertiesConfigurer((BeanDefinitionRegistry)context, (String)TEST_CONFIGURER_BEAN, (String)TEST_PROPERTIES_FILE_BEAN);
        SpringUtils.addStringBean((BeanDefinitionRegistry)context, (String)TEST_NAME_BEAN, (String)"${testNamePropBlank}");
        context.refresh();
        Assert.assertEquals((Object)"", (Object)context.getBean(TEST_NAME_BEAN));
    }

    @Test
    public void propertiesConfigurerList() {
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)new FileSystemXmlApplicationContext(TEST_SPRING_FILE));
        SpringUtils.addPropertiesConfigurer((BeanDefinitionRegistry)context, (String)TEST_CONFIGURER_BEAN, (String)TEST_PROPERTIES_FILES_BEAN);
        SpringUtils.addStringBean((BeanDefinitionRegistry)context, (String)TEST_NAME_BEAN, (String)"${testNameProp}");
        context.refresh();
        Assert.assertEquals((Object)TEST_VALUE_PROP_OVERRIDE, (Object)context.getBean(TEST_NAME_BEAN));
    }
}

