/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.DecodingStrategy;
import org.marketcetera.util.unicode.IOTestBase;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.SignatureCharset;

@Ignore
public abstract class DecoderTestBase
extends IOTestBase {
    protected abstract String decode(byte[] var1) throws Exception;

    private void testDecode(byte[] bytes, String string) throws Exception {
        Assert.assertEquals((Object)string, (Object)this.decode(bytes));
    }

    protected abstract String decode(SignatureCharset var1, byte[] var2) throws Exception;

    private void testDecode(SignatureCharset sc, byte[] bytes, String string) throws Exception {
        Assert.assertEquals((Object)string, (Object)this.decode(sc, bytes));
    }

    protected abstract String decode(DecodingStrategy var1, SignatureCharset var2, byte[] var3) throws Exception;

    private void testDecode(DecodingStrategy strategy, SignatureCharset sc, byte[] bytes, String string) throws Exception {
        Assert.assertEquals((Object)string, (Object)this.decode(strategy, sc, bytes));
    }

    @Override
    protected void testNative() throws Exception {
        this.testDecode(UnicodeData.HELLO_EN_NAT, "Hello");
        this.testDecode(null, UnicodeData.HELLO_EN_NAT, "Hello");
        this.testDecode(null, null, UnicodeData.HELLO_EN_NAT, "Hello");
        this.testDecode(ArrayUtils.EMPTY_BYTE_ARRAY, "");
        this.testDecode(null, ArrayUtils.EMPTY_BYTE_ARRAY, "");
        this.testDecode(null, null, ArrayUtils.EMPTY_BYTE_ARRAY, "");
    }

    @Override
    protected void testSignatureCharset(SignatureCharset sc, byte[] bytes) throws Exception {
        this.testDecode(sc, bytes, "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        this.testDecode(sc, ArrayUtils.EMPTY_BYTE_ARRAY, "");
    }

    @Override
    protected void testStrategy(DecodingStrategy strategy, SignatureCharset sc, String string, byte[] bytes) throws Exception {
        this.testDecode(strategy, sc, bytes, string);
        this.testDecode(strategy, sc, ArrayUtils.EMPTY_BYTE_ARRAY, "");
        this.testDecode(strategy, SignatureCharset.UTF8_UTF8, ArrayUtils.addAll((byte[])Signature.UTF8.getMark(), (byte[])UnicodeData.COMBO_UTF8), "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        this.testDecode(strategy, SignatureCharset.UTF16BE_UTF16BE, ArrayUtils.addAll((byte[])Signature.UTF16BE.getMark(), (byte[])UnicodeData.COMBO_UTF16BE), "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        this.testDecode(strategy, SignatureCharset.UTF16LE_UTF16LE, ArrayUtils.addAll((byte[])Signature.UTF16LE.getMark(), (byte[])UnicodeData.COMBO_UTF16LE), "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        this.testDecode(strategy, SignatureCharset.UTF32BE_UTF32BE, ArrayUtils.addAll((byte[])Signature.UTF32BE.getMark(), (byte[])UnicodeData.COMBO_UTF32BE), "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
        this.testDecode(strategy, SignatureCharset.UTF32LE_UTF32LE, ArrayUtils.addAll((byte[])Signature.UTF32LE.getMark(), (byte[])UnicodeData.COMBO_UTF32LE), "Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e");
    }
}

