/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.CharBuffer;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.file.CloseableRegistry;
import org.marketcetera.util.file.InputStreamWrapper;
import org.marketcetera.util.file.ReaderWrapper;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.UnicodeInputStreamReader;

public class ReaderTest
extends TestCaseBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void regularReader() throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            ByteArrayInputStream is = new ByteArrayInputStream(UnicodeData.HELLO_EN_NAT);
            r.register((Closeable)new InputStreamWrapper((InputStream)is));
            UnicodeInputStreamReader reader = new UnicodeInputStreamReader((InputStream)is);
            r.register((Closeable)new ReaderWrapper((Reader)reader));
            Assert.assertNull((Object)reader.getDecodingStrategy());
            Assert.assertNull((Object)reader.getRequestedSignatureCharset());
            Assert.assertNull((Object)reader.getSignatureCharset());
            Assert.assertTrue((boolean)reader.ready());
            Assert.assertFalse((boolean)reader.markSupported());
            try {
                reader.mark(0);
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader.reset();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.assertEquals((long)"Hello".charAt(0), (long)reader.read());
            Assert.assertEquals((long)1L, (long)reader.skip(1L));
            char[] charArray = new char[1];
            Assert.assertEquals((long)1L, (long)reader.read(charArray));
            Assert.assertEquals((long)"Hello".charAt(2), (long)charArray[0]);
            charArray = new char[3];
            Assert.assertEquals((long)1L, (long)reader.read(charArray, 1, 1));
            Assert.assertEquals((long)"Hello".charAt(3), (long)charArray[1]);
            CharBuffer charBuffer = CharBuffer.allocate(10);
            Assert.assertEquals((long)1L, (long)reader.read(charBuffer));
            Assert.assertEquals((long)"Hello".charAt(4), (long)charBuffer.get(0));
            Assert.assertEquals((long)-1L, (long)reader.read());
            Assert.assertEquals((long)-1L, (long)reader.read(charArray));
            Assert.assertEquals((long)-1L, (long)reader.read(charArray, 1, 1));
            Assert.assertEquals((long)-1L, (long)reader.read(charBuffer));
            Assert.assertFalse((boolean)reader.ready());
            reader.close();
            reader.close();
            try {
                reader.read();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader.ready();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void emptyReader() throws Exception {
        try (CloseableRegistry r = new CloseableRegistry();){
            ByteArrayInputStream is = new ByteArrayInputStream(ArrayUtils.EMPTY_BYTE_ARRAY);
            r.register((Closeable)new InputStreamWrapper((InputStream)is));
            UnicodeInputStreamReader reader = new UnicodeInputStreamReader((InputStream)is);
            r.register((Closeable)new ReaderWrapper((Reader)reader));
            Assert.assertNull((Object)reader.getDecodingStrategy());
            Assert.assertNull((Object)reader.getRequestedSignatureCharset());
            Assert.assertNull((Object)reader.getSignatureCharset());
            Assert.assertFalse((boolean)reader.ready());
            Assert.assertFalse((boolean)reader.markSupported());
            try {
                reader.mark(0);
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader.reset();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Assert.assertEquals((long)-1L, (long)reader.read());
            char[] charArray = new char[1];
            Assert.assertEquals((long)-1L, (long)reader.read(charArray));
            charArray = new char[3];
            Assert.assertEquals((long)-1L, (long)reader.read(charArray, 1, 1));
            CharBuffer charBuffer = CharBuffer.allocate(10);
            Assert.assertEquals((long)-1L, (long)reader.read(charBuffer));
            reader.close();
            reader.close();
            try {
                reader.read();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader.ready();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

