/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.unicode.Signature;

public class SignatureTest
extends TestCaseBase {
    private static void single(Signature[] allCandidates, Signature signature, int length) {
        Assert.assertNotNull((Object)signature.getMark());
        Assert.assertEquals((long)length, (long)signature.getLength());
        byte[] data = signature.getMark();
        Assert.assertTrue((boolean)signature.prefixMatch(data));
        Signature[] candidates = new Signature[]{signature};
        Assert.assertEquals((Object)signature, (Object)Signature.getPrefixMatch((Signature[])candidates, (byte[])data));
        Assert.assertEquals((Object)signature, (Object)Signature.getPrefixMatch((Signature[])allCandidates, (byte[])data));
        data = ArrayUtils.addAll((byte[])data, (byte[])new byte[]{1, 2});
        Assert.assertTrue((boolean)signature.prefixMatch(data));
        Assert.assertEquals((Object)signature, (Object)Signature.getPrefixMatch((Signature[])candidates, (byte[])data));
        Assert.assertEquals((Object)signature, (Object)Signature.getPrefixMatch((Signature[])allCandidates, (byte[])data));
        data[0] = 1;
        Assert.assertEquals((Object)(length == 0 ? 1 : 0), (Object)signature.prefixMatch(data));
        Assert.assertEquals((Object)(length == 0 ? signature : null), (Object)Signature.getPrefixMatch((Signature[])candidates, (byte[])data));
        Assert.assertEquals((Object)Signature.NONE, (Object)Signature.getPrefixMatch((Signature[])allCandidates, (byte[])data));
        data = new byte[]{1};
        Assert.assertEquals((Object)(length == 0 ? 1 : 0), (Object)signature.prefixMatch(data));
        Assert.assertEquals((Object)(length == 0 ? signature : null), (Object)Signature.getPrefixMatch((Signature[])candidates, (byte[])data));
        Assert.assertEquals((Object)Signature.NONE, (Object)Signature.getPrefixMatch((Signature[])allCandidates, (byte[])data));
        data = new byte[]{0, 0};
        Assert.assertEquals((Object)(length == 0 ? 1 : 0), (Object)signature.prefixMatch(data));
        Assert.assertEquals((Object)(length == 0 ? signature : null), (Object)Signature.getPrefixMatch((Signature[])candidates, (byte[])data));
        Assert.assertEquals((Object)Signature.NONE, (Object)Signature.getPrefixMatch((Signature[])allCandidates, (byte[])data));
    }

    private static void multi(Signature signature, int length) {
        SignatureTest.single(new Signature[]{Signature.NONE, Signature.UTF8, Signature.UTF16BE, Signature.UTF16LE, Signature.UTF32BE, Signature.UTF32LE}, signature, length);
        SignatureTest.single(new Signature[]{Signature.UTF8, Signature.UTF16BE, Signature.UTF16LE, Signature.UTF32BE, Signature.UTF32LE, Signature.NONE}, signature, length);
        SignatureTest.single(new Signature[]{Signature.UTF16LE, Signature.UTF32LE, Signature.UTF16BE, Signature.UTF32BE, Signature.UTF8, Signature.NONE}, signature, length);
    }

    @Test
    public void all() {
        SignatureTest.multi(Signature.NONE, 0);
        SignatureTest.multi(Signature.UTF8, 3);
        SignatureTest.multi(Signature.UTF16BE, 2);
        SignatureTest.multi(Signature.UTF16LE, 2);
        SignatureTest.multi(Signature.UTF32BE, 4);
        SignatureTest.multi(Signature.UTF32LE, 4);
    }

    @Test
    public void multiMatch() {
        byte[] data = Signature.UTF8.getMark();
        Assert.assertNull((Object)Signature.getPrefixMatch((Signature[])Signature.EMPTY_ARRAY, (byte[])data));
        Assert.assertNull((Object)Signature.getPrefixMatch((Signature[])new Signature[]{Signature.UTF16BE, Signature.UTF16LE, Signature.UTF32BE, Signature.UTF32LE}, (byte[])data));
        Assert.assertEquals((Object)Signature.NONE, (Object)Signature.getPrefixMatch((Signature[])new Signature[]{Signature.NONE, Signature.UTF16BE, Signature.UTF16LE, Signature.UTF32BE, Signature.UTF32LE}, (byte[])data));
    }

    @Test
    public void longestSignature() {
        Assert.assertEquals((long)4L, (long)Signature.getLongestLength());
    }
}

