/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.test.TestCaseBase;
import org.marketcetera.util.test.UnicodeData;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.UnicodeCharset;

public class UnicodeCharsetTest
extends TestCaseBase {
    private static void singlePrefix(UnicodeCharset charset, String name, byte[] dataIn, byte[] dataOut) throws Exception {
        Assert.assertEquals((Object)name, (Object)charset.getName());
        Assert.assertTrue((boolean)charset.isSupported());
        charset.assertSupported();
        Assert.assertNull((Object)charset.decode(null));
        Assert.assertNull((Object)charset.decode(null, 0, 0));
        Assert.assertNull((Object)charset.encode(null));
        Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)charset.decode(dataIn));
        byte[] inEx = ArrayUtils.addAll((byte[])new byte[]{0, 1}, (byte[])dataIn);
        inEx = ArrayUtils.addAll((byte[])inEx, (byte[])new byte[]{0, 1});
        Assert.assertEquals((Object)"Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e", (Object)charset.decode(inEx, 2, inEx.length - 4));
        Assert.assertArrayEquals((byte[])dataOut, (byte[])charset.encode("Hello Spr\u00e5k \u0393\u0395\u0399\u0391 \u03a3\u039f\u03a5 \u0645\u0646\u0632\u0644 \u3055\u3088\u3046\u306a\u3089 \ud800\udc88 \ud800\udc89 \ud834\udd1e"));
    }

    private static void single(UnicodeCharset charset, String name, byte[] data) throws Exception {
        UnicodeCharsetTest.singlePrefix(charset, name, data, data);
    }

    @Test
    public void utf8() throws Exception {
        UnicodeCharsetTest.single(UnicodeCharset.UTF8, "UTF-8", UnicodeData.COMBO_UTF8);
    }

    @Test
    public void utf16() throws Exception {
        UnicodeCharsetTest.single(UnicodeCharset.UTF16BE, "UTF-16BE", UnicodeData.COMBO_UTF16BE);
        UnicodeCharsetTest.single(UnicodeCharset.UTF16LE, "UTF-16LE", UnicodeData.COMBO_UTF16LE);
        byte[] dataOut = ArrayUtils.addAll((byte[])Signature.UTF16BE.getMark(), (byte[])UnicodeData.COMBO_UTF16BE);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF16, "UTF-16", UnicodeData.COMBO_UTF16BE, dataOut);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF16, "UTF-16", ArrayUtils.addAll((byte[])Signature.UTF16BE.getMark(), (byte[])UnicodeData.COMBO_UTF16BE), dataOut);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF16, "UTF-16", ArrayUtils.addAll((byte[])Signature.UTF16LE.getMark(), (byte[])UnicodeData.COMBO_UTF16LE), dataOut);
    }

    @Test
    public void utf32() throws Exception {
        UnicodeCharsetTest.single(UnicodeCharset.UTF32BE, "UTF-32BE", UnicodeData.COMBO_UTF32BE);
        UnicodeCharsetTest.single(UnicodeCharset.UTF32LE, "UTF-32LE", UnicodeData.COMBO_UTF32LE);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF32, "UTF-32", UnicodeData.COMBO_UTF32BE, UnicodeData.COMBO_UTF32BE);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF32, "UTF-32", ArrayUtils.addAll((byte[])Signature.UTF32BE.getMark(), (byte[])UnicodeData.COMBO_UTF32BE), UnicodeData.COMBO_UTF32BE);
        UnicodeCharsetTest.singlePrefix(UnicodeCharset.UTF32, "UTF-32", ArrayUtils.addAll((byte[])Signature.UTF32LE.getMark(), (byte[])UnicodeData.COMBO_UTF32LE), UnicodeData.COMBO_UTF32BE);
    }
}

