/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.apache.commons.lang.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.ws.stateful.AuthServiceImpl;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateful.FixedAuthenticator;
import org.marketcetera.util.ws.stateful.Messages;
import org.marketcetera.util.ws.stateful.ServiceImplTestBase;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

public class AuthServiceImplTest
extends ServiceImplTestBase<Object> {
    private static final FixedAuthenticator TEST_AUTHENTICATOR = new FixedAuthenticator();
    private static final String TEST_USER = "metc";
    private static final String TEST_USER_D = "metcD";
    private static final char[] TEST_PASSWORD = "metc".toCharArray();
    private static final char[] NUL_VALUE = StringUtils.repeat((String)"\u0000", (int)TEST_PASSWORD.length).toCharArray();

    @Test
    public void all() throws Exception {
        AuthServiceImpl impl = new AuthServiceImpl((Authenticator)TEST_AUTHENTICATOR, this.TEST_MANAGER);
        this.single(impl, null);
        Assert.assertEquals((Object)TEST_AUTHENTICATOR, (Object)impl.getAuthenticator());
        char[] password = (char[])TEST_PASSWORD.clone();
        SessionId id = impl.login(this.TEST_CONTEXT, TEST_USER, password);
        Assert.assertArrayEquals((char[])NUL_VALUE, (char[])password);
        Assert.assertEquals((Object)TEST_USER, (Object)this.TEST_MANAGER.get(id).getUser());
        ClientContext context = this.getContext(id);
        impl.logout(context);
        impl.logout(context);
        password = (char[])TEST_PASSWORD.clone();
        SessionId id1 = impl.login(this.TEST_CONTEXT, TEST_USER, password);
        password = (char[])TEST_PASSWORD.clone();
        SessionId id2 = impl.login(this.TEST_CONTEXT, TEST_USER, password);
        Assert.assertFalse((boolean)id1.equals((Object)id2));
        Assert.assertEquals((Object)TEST_USER, (Object)this.TEST_MANAGER.get(id1).getUser());
        Assert.assertEquals((Object)TEST_USER, (Object)this.TEST_MANAGER.get(id2).getUser());
        impl.logout(this.getContext(id1));
        Assert.assertNull((Object)this.TEST_MANAGER.get(id1));
        Assert.assertEquals((Object)TEST_USER, (Object)this.TEST_MANAGER.get(id2).getUser());
        impl.logout(this.getContext(id2));
        Assert.assertNull((Object)this.TEST_MANAGER.get(id2));
        password = (char[])TEST_PASSWORD.clone();
        try {
            impl.login(this.TEST_CONTEXT, TEST_USER_D, password);
            Assert.fail();
        }
        catch (RemoteException ex) {
            Assert.assertEquals((Object)Messages.BAD_CREDENTIALS, (Object)((I18NException)ex.getCause()).getI18NBoundMessage());
        }
        Assert.assertArrayEquals((char[])NUL_VALUE, (char[])password);
    }
}

