/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateful;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.stateless.ClientContextTestBase;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.SessionId;

public class ClientContextTest
extends ClientContextTestBase {
    private static final SessionId TEST_SESSION = SessionId.generate();
    private static final SessionId TEST_SESSION_D = SessionId.generate();

    protected static void fillContext(ClientContext context) {
        ClientContextTestBase.fillContext((StatelessClientContext)context);
        context.setSessionId(TEST_SESSION);
    }

    @Test
    public void all() {
        ClientContext context = new ClientContext();
        ClientContextTest.fillContext(context);
        ClientContext copy = new ClientContext();
        ClientContextTest.fillContext(copy);
        ClientContext empty = new ClientContext();
        ClientContextTest.single((StatelessClientContext)context, (StatelessClientContext)copy, (StatelessClientContext)empty, "; session " + TEST_SESSION);
        Assert.assertEquals((Object)TEST_SESSION, (Object)context.getSessionId());
        Assert.assertNull((Object)empty.getSessionId());
        context.setSessionId(TEST_SESSION_D);
        Assert.assertEquals((Object)TEST_SESSION_D, (Object)context.getSessionId());
        Assert.assertEquals((Object)("Protocol version null; application null; client null; locale ''; session " + TEST_SESSION_D), (Object)context.toString());
        context.setSessionId(null);
        Assert.assertNull((Object)context.getSessionId());
        Assert.assertEquals((Object)"Protocol version null; application null; client null; locale ''; session null", (Object)context.toString());
        Assert.assertEquals((Object)empty, (Object)context);
    }
}

