/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.file;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.marketcetera.util.file.FileType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SmartLinksDirectoryWalker.java 17784 2018-11-19 21:08:09Z colin $")
public abstract class SmartLinksDirectoryWalker
extends DirectoryWalker<String> {
    private boolean mFollowLinks;

    protected SmartLinksDirectoryWalker(boolean followLinks) {
        this.mFollowLinks = followLinks;
    }

    protected SmartLinksDirectoryWalker(boolean followLinks, FileFilter filter, int depthLimit) {
        super(filter, depthLimit);
        this.mFollowLinks = followLinks;
    }

    protected SmartLinksDirectoryWalker(boolean followLinks, IOFileFilter directoryFilter, IOFileFilter fileFilter, int depthLimit) {
        super(directoryFilter, fileFilter, depthLimit);
        this.mFollowLinks = followLinks;
    }

    protected boolean handleDirectory(File directory, int depth, Collection<String> results) throws IOException {
        if (FileType.get(directory) != FileType.LINK_DIR || this.getFollowLinks()) {
            return true;
        }
        this.handleFile(directory, depth, results);
        return false;
    }

    public boolean getFollowLinks() {
        return this.mFollowLinks;
    }

    public void apply(File root, Collection<String> results) throws IOException {
        FileType type = FileType.get(root);
        if (type == FileType.NONEXISTENT) {
            return;
        }
        if (type.isFile() || !this.getFollowLinks() && type.isSymbolicLink()) {
            this.handleFile(root, 0, results);
            return;
        }
        this.walk(root, results);
    }

    public void apply(File root) throws IOException {
        this.apply(root, null);
    }

    public void apply(String name, Collection<String> results) throws IOException {
        this.apply(new File(name), results);
    }

    public void apply(String name) throws IOException {
        this.apply(name, null);
    }
}

