/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.unicode;

import org.apache.commons.lang.ArrayUtils;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.unicode.Signature;
import org.marketcetera.util.unicode.UnicodeCharset;

@ClassVersion(value="$Id: SignatureCharset.java 16154 2012-07-14 16:34:05Z colin $")
public enum SignatureCharset {
    NONE_UTF8(Signature.NONE, UnicodeCharset.UTF8),
    NONE_UTF16BE(Signature.NONE, UnicodeCharset.UTF16BE),
    NONE_UTF16LE(Signature.NONE, UnicodeCharset.UTF16LE),
    NONE_UTF32BE(Signature.NONE, UnicodeCharset.UTF32BE),
    NONE_UTF32LE(Signature.NONE, UnicodeCharset.UTF32LE),
    UTF8_UTF8(Signature.UTF8, UnicodeCharset.UTF8),
    UTF16BE_UTF16BE(Signature.UTF16BE, UnicodeCharset.UTF16BE),
    UTF16LE_UTF16LE(Signature.UTF16LE, UnicodeCharset.UTF16LE),
    UTF32BE_UTF32BE(Signature.UTF32BE, UnicodeCharset.UTF32BE),
    UTF32LE_UTF32LE(Signature.UTF32LE, UnicodeCharset.UTF32LE);

    private final Signature mSignature;
    private final UnicodeCharset mCharset;

    private SignatureCharset(Signature signature, UnicodeCharset charset) {
        this.mSignature = signature;
        this.mCharset = charset;
    }

    public Signature getSignature() {
        return this.mSignature;
    }

    public UnicodeCharset getCharset() {
        return this.mCharset;
    }

    public boolean isSupported() {
        return this.getCharset().isSupported();
    }

    public void assertSupported() throws I18NException {
        this.getCharset().assertSupported();
    }

    public String decode(byte[] data) throws I18NException {
        if (data == null) {
            return null;
        }
        this.assertSupported();
        int len = this.getSignature().getLength();
        return this.getCharset().decode(data, len, data.length - len);
    }

    public byte[] encode(String data) throws I18NException {
        if (data == null) {
            return null;
        }
        this.assertSupported();
        return ArrayUtils.addAll((byte[])this.getSignature().getMark(), (byte[])this.getCharset().encode(data));
    }
}

