/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.stateless;

import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateless.Messages;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.tags.EqualsTagFilter;
import org.marketcetera.util.ws.tags.Tag;
import org.marketcetera.util.ws.tags.TagFilter;
import org.marketcetera.util.ws.tags.VersionId;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: StatelessRemoteCall.java 17411 2017-04-28 14:50:38Z colin $")
public class StatelessRemoteCall {
    public static final EqualsTagFilter DEFAULT_VERSION_FILTER = new EqualsTagFilter(VersionId.SELF, Messages.VERSION_MISMATCH);
    private final TagFilter mVersionIdFilter;
    private final TagFilter mAppIdFilter;
    private final TagFilter mClientIdFilter;

    public StatelessRemoteCall(TagFilter versionIdFilter, TagFilter appIdFilter, TagFilter clientIdFilter) {
        this.mVersionIdFilter = versionIdFilter;
        this.mAppIdFilter = appIdFilter;
        this.mClientIdFilter = clientIdFilter;
    }

    public StatelessRemoteCall() {
        this.mVersionIdFilter = DEFAULT_VERSION_FILTER;
        this.mAppIdFilter = null;
        this.mClientIdFilter = null;
    }

    public TagFilter getVersionIdFilter() {
        return this.mVersionIdFilter;
    }

    public TagFilter getAppIdFilter() {
        return this.mAppIdFilter;
    }

    public TagFilter getClientIdFilter() {
        return this.mClientIdFilter;
    }

    protected static void assertFilterMatch(TagFilter filter, Tag tag) throws I18NException {
        if (filter != null) {
            filter.assertMatch(tag);
        }
    }

    protected void assertFilterMatch(StatelessClientContext context) throws I18NException {
        StatelessRemoteCall.assertFilterMatch(this.getVersionIdFilter(), context.getVersionId());
        StatelessRemoteCall.assertFilterMatch(this.getAppIdFilter(), context.getAppId());
        StatelessRemoteCall.assertFilterMatch(this.getClientIdFilter(), context.getClientId());
    }

    protected void startCall(StatelessClientContext context) {
        Messages.CALL_START.debug(this, context);
    }

    protected void handleSuccess(StatelessClientContext context) {
        Messages.CALL_SUCCESS.debug(this, context);
    }

    protected RemoteException wrapFailure(StatelessClientContext context, Throwable t) {
        Messages.CALL_FAILURE.debug(this, context);
        return new RemoteException(t);
    }
}

