/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.util.ws.tags;

import java.io.Serializable;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.tags.Messages;
import org.marketcetera.util.ws.tags.SessionExpiredException;
import org.marketcetera.util.ws.tags.SessionId;
import org.marketcetera.util.ws.tags.SessionRequiredException;
import org.marketcetera.util.ws.tags.Tag;
import org.marketcetera.util.ws.tags.TagFilter;

@ClassVersion(value="$Id: ValidSessionTagFilter.java 17411 2017-04-28 14:50:38Z colin $")
public class ValidSessionTagFilter<T>
implements TagFilter {
    private final SessionManager<T> mSessionManager;

    public ValidSessionTagFilter(SessionManager<T> sessionManager) {
        this.mSessionManager = sessionManager;
    }

    public SessionManager<T> getSessionManager() {
        return this.mSessionManager;
    }

    @Override
    public void assertMatch(Tag inTag) throws I18NException {
        if (this.getSessionManager() == null) {
            return;
        }
        if (inTag == null) {
            throw new SessionRequiredException(Messages.SESSION_REQUIRED);
        }
        if (inTag instanceof SessionId && this.getSessionManager().get((SessionId)inTag) != null) {
            return;
        }
        throw new SessionExpiredException(new I18NBoundMessage1P(Messages.SESSION_EXPIRED, (Serializable)inTag));
    }
}

