/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.javascript;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.DetectionScript;
import org.markysoft.vani.core.annotation.JavaScript;
import org.markysoft.vani.core.annotation.JsCallFunction;
import org.markysoft.vani.core.javascript.JavaScriptCallFunction;
import org.markysoft.vani.core.javascript.JavaScriptReadException;
import org.markysoft.vani.core.javascript.JavaScriptSource;
import org.markysoft.vani.core.util.VaniReflectionUtil;
import org.openqa.selenium.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class JavaScriptLoader {
    private Log logger = LogFactory.getLog(JavaScriptLoader.class);
    @Autowired
    private VaniReflectionUtil reflectionUtil;

    public <T> JavaScriptSource<T> load(JavaScript javaScript, Class<T> jsInterface, VaniContext vaniContext) throws JavaScriptReadException {
        String[] sourcePaths = javaScript.sources();
        if (!(sourcePaths != null && sourcePaths.length != 0 || StringUtils.isEmpty((Object)javaScript.source()))) {
            sourcePaths = new String[]{javaScript.source()};
        }
        StringBuilder source = new StringBuilder();
        if (sourcePaths != null) {
            for (String sourcePath : sourcePaths) {
                if (StringUtils.isEmpty((Object)sourcePath)) continue;
                if (sourcePath.startsWith("classpath")) {
                    String classpath = sourcePath.replace("classpath:", "");
                    source.append((CharSequence)this.fromClasspath(classpath, vaniContext));
                } else {
                    source.append((CharSequence)this.fromFilesystem(sourcePath, vaniContext));
                }
                source.append("\n");
            }
        }
        JavaScriptSource<T> result = new JavaScriptSource<T>(jsInterface, source.toString());
        this.setDetectedMethod(result);
        this.setCallFunction(result, vaniContext);
        return result;
    }

    protected <T> void setDetectedMethod(JavaScriptSource<T> jsSource) {
        Method detectionMethod = this.reflectionUtil.getAnnotatedMethodWith(jsSource.getJsInterface(), DetectionScript.class, null);
        if (detectionMethod != null) {
            DetectionScript detectionAnnotation = detectionMethod.getDeclaredAnnotation(DetectionScript.class);
            jsSource.setDetectionScriptAnnotation(detectionAnnotation);
        }
    }

    protected <T> void setCallFunction(JavaScriptSource<T> jsSource, VaniContext vaniContext) {
        Method callMethod = this.reflectionUtil.getAnnotatedMethodWith(jsSource.getJsInterface(), JsCallFunction.class, null);
        if (callMethod != null) {
            JsCallFunction callFuncAnnotation = callMethod.getDeclaredAnnotation(JsCallFunction.class);
            if (StringUtils.isEmpty((Object)callFuncAnnotation.value())) {
                this.logger.warn((Object)("js-" + jsSource.getJsInterface() + " has callFunction without path!"));
                return;
            }
            String source = "";
            String sourcePath = callFuncAnnotation.value();
            if (sourcePath.startsWith("classpath")) {
                String classpath = sourcePath.replace("classpath:", "");
                source = this.fromClasspath(classpath, vaniContext).toString();
            } else {
                source = this.fromFilesystem(sourcePath, vaniContext).toString();
            }
            if (!StringUtils.isEmpty((Object)source)) {
                JavaScriptCallFunction callFunction = new JavaScriptCallFunction(callFuncAnnotation, source, callMethod);
                jsSource.setJsCallFunction(callFunction);
            }
        }
    }

    protected StringBuilder fromClasspath(String classpath, VaniContext vaniContext) throws JavaScriptReadException {
        Set<String> paths = this.getResourcesPathFromClasspath(classpath, vaniContext);
        if (paths.isEmpty()) {
            this.logger.warn((Object)("no matching js-script files for classpath '" + classpath + "' found!"));
        }
        StringBuilder source = new StringBuilder();
        for (String path : paths) {
            InputStream is;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((is = ClassLoader.class.getResourceAsStream(path)) != null) {
                try {
                    source.append(IOUtils.readFully((InputStream)is));
                    source.append("\n");
                    continue;
                }
                catch (Exception ex) {
                    throw new JavaScriptReadException("cannot read classpath js-file with path '" + path + "': " + ex.getMessage(), ex);
                }
            }
            this.logger.warn((Object)("js-script with classpath '" + path + "' not found!"));
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuilder fromFilesystem(String sourcePath, VaniContext vaniContext) throws JavaScriptReadException {
        StringBuilder result = new StringBuilder();
        List<Object> paths = new ArrayList();
        try {
            paths = this.getResourcesPathFromFilesystem(sourcePath);
        }
        catch (Throwable ex) {
            throw new JavaScriptReadException("cannot collect paths for property source '" + sourcePath + "': " + ex.getMessage(), ex);
        }
        if (paths.isEmpty()) {
            this.logger.warn((Object)("requested resource '" + sourcePath + "' not found!"));
            return result;
        }
        for (Path path : paths) {
            try {
                InputStream is = Files.newInputStream(path, new OpenOption[0]);
                if (is != null) {
                    try {
                        result.append(IOUtils.readFully((InputStream)is));
                    }
                    finally {
                        is.close();
                    }
                    result.append("\n");
                    continue;
                }
                this.logger.warn((Object)("resource path '" + path + "' not found!"));
            }
            catch (Exception ex) {
                throw new JavaScriptReadException("cannot read java script source with path '" + path + "' from filesystem: " + ex.getMessage(), ex);
            }
        }
        return result;
    }

    protected List<Path> getResourcesPathFromFilesystem(String resourcePath) throws Throwable {
        ArrayList<Path> result = new ArrayList<Path>();
        int idx = resourcePath.lastIndexOf("/");
        String path = "";
        if (idx > -1) {
            path = resourcePath.substring(0, idx);
            resourcePath = resourcePath.substring(idx + 1);
        }
        DirectoryStream<Path> stream = null;
        if (StringUtils.isEmpty((Object)path)) {
            path = ".";
        }
        Path dir = Paths.get(path, new String[0]);
        stream = Files.newDirectoryStream(dir, resourcePath);
        stream.forEach(p -> result.add((Path)p));
        return result;
    }

    protected Set<String> getResourcesPathFromClasspath(String classpath, VaniContext context) {
        HashSet<String> result = null;
        boolean isPathUsed = classpath.contains("/");
        String path = "";
        if (isPathUsed) {
            int idx = classpath.lastIndexOf("/");
            path = classpath.substring(0, idx);
            classpath = classpath.substring(idx + 1);
        }
        result = context.getReflections().getResources(Pattern.compile(classpath));
        if (isPathUsed) {
            HashSet<String> matches = new HashSet<String>();
            Pattern fullPattern = Pattern.compile(path + "/" + classpath);
            for (String entry : result) {
                if (!fullPattern.matcher(entry).find()) continue;
                matches.add(entry);
            }
            result = matches;
        }
        return result;
    }

    public void setReflectionUtil(VaniReflectionUtil reflectionUtil) {
        this.reflectionUtil = reflectionUtil;
    }
}

