/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.markysoft.vani.core.javascript.GlobalReferenceHolder;
import org.markysoft.vani.core.javascript.JQuery;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class JQueryElement
implements WebElement,
GlobalReferenceHolder {
    private JQuery jquery;
    private WebDriver webDriver;
    private String reference;
    private String selector;
    private long length;

    public JQueryElement() {
    }

    public JQueryElement(JQuery jquery, WebDriver webDriver, String ref) {
        this.jquery = jquery;
        this.webDriver = webDriver;
        this.reference = ref;
        this.selector = (String)jquery.objectAttribute(this, "selector", webDriver);
        this.length = (Long)jquery.objectAttribute(this, "length", webDriver);
    }

    public JQueryElement(JQuery jquery, WebDriver webDriver, WebElement webElement) {
        this.jquery = jquery;
        this.webDriver = webDriver;
        this.reference = jquery.find(null, (WebElement)webElement).reference;
        this.selector = (String)jquery.objectAttribute(this, "selector", webDriver);
        this.length = (Long)jquery.objectAttribute(this, "length", webDriver);
    }

    public JQueryElement(JQuery jquery, WebDriver webDriver, List<WebElement> webElements) {
        this.jquery = jquery;
        this.webDriver = webDriver;
        this.reference = jquery.find(null, webElements).reference;
        this.selector = (String)jquery.objectAttribute(this, "selector", webDriver);
        this.length = (Long)jquery.objectAttribute(this, "length", webDriver);
    }

    public <X> X getScreenshotAs(OutputType<X> target) throws WebDriverException {
        WebElement first = this.get(0);
        return (X)(first != null ? first.getScreenshotAs(target) : null);
    }

    public void click() {
        this.get(0).click();
    }

    public void submit() {
        this.jquery.submit(this, this.webDriver);
    }

    public long getLength() {
        return this.length;
    }

    public String getSelector() {
        return this.selector;
    }

    public void sendKeys(CharSequence ... keysToSend) {
        StringBuilder builder = new StringBuilder();
        if (keysToSend != null) {
            for (CharSequence keys : keysToSend) {
                builder.append(keys);
            }
        }
        this.val(builder.toString());
    }

    public void clear() {
        this.val("");
    }

    public String getTagName() {
        String tagName = this.prop("tagName");
        return tagName;
    }

    public String getAttribute(String name) {
        String result = this.attr(name);
        return result;
    }

    public boolean isSelected() {
        boolean result = this.is(":selected") || this.is(":checked");
        return result;
    }

    public boolean isEnabled() {
        boolean result = this.is(":enabled");
        return result;
    }

    public String getText() {
        return this.text();
    }

    public List<WebElement> findElements(By by) {
        List<WebElement> wrappedElements = this.get();
        ArrayList<WebElement> result = new ArrayList<WebElement>(30);
        wrappedElements.forEach(e -> result.add(new JQueryElement(this.jquery, this.webDriver, e.findElements(by))));
        return result;
    }

    public WebElement findElement(By by) {
        List<WebElement> wrappedElements = this.get();
        ArrayList<WebElement> result = new ArrayList<WebElement>(30);
        wrappedElements.forEach(e -> result.addAll(e.findElements(by)));
        return new JQueryElement(this.jquery, this.webDriver, result);
    }

    public boolean isDisplayed() {
        boolean result = this.is(":visible");
        return result;
    }

    public Point getLocation() {
        Point result = this.offset();
        return result;
    }

    public Dimension getSize() {
        Dimension result = new Dimension((int)this.width(), (int)this.height());
        return result;
    }

    public Rectangle getRect() {
        Rectangle result = new Rectangle(this.getLocation(), this.getSize());
        return result;
    }

    public String getCssValue(String propertyName) {
        String result = this.css(propertyName);
        return result;
    }

    public List<WebElement> get() {
        return this.jquery.get(this, this.webDriver);
    }

    public WebElement get(int index) {
        return this.jquery.get(this, index, this.webDriver);
    }

    public boolean hasMatches() {
        boolean result = this.get(0) != null;
        return result;
    }

    public boolean is(String expr) {
        return this.jquery.is(this, expr, this.webDriver);
    }

    public String prop(String name) {
        return this.jquery.prop(this, name, this.webDriver);
    }

    public String attr(String name) {
        return this.jquery.attr(this, name, this.webDriver);
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    public JQueryElement find(String selector) {
        JQueryElement result = this.jquery.find((GlobalReferenceHolder)this, selector, this.webDriver);
        return result;
    }

    public String text() {
        return this.jquery.text(this, this.webDriver);
    }

    public String css(String propertyName) {
        return this.jquery.css(this, propertyName, this.webDriver);
    }

    public void val(String value) {
        this.jquery.val(this, value, this.webDriver);
    }

    public void val() {
        this.jquery.val(this, this.webDriver);
    }

    public double width() {
        return this.jquery.width(this, this.webDriver);
    }

    public double height() {
        return this.jquery.height(this, this.webDriver);
    }

    public Point offset() {
        return null;
    }

    public void each(Consumer<JQueryElement> consumer) {
        for (WebElement element : this.get()) {
            consumer.accept(this.jquery.find(null, element, this.webDriver));
        }
    }

    public JQueryElement prev(String selector) {
        return this.jquery.prev(this, selector, this.webDriver);
    }

    public String toString() {
        return "JQuery[selector: " + this.selector + ", length: " + this.length + "]";
    }

    public JQueryElement last() {
        return this.jquery.last(this, this.webDriver);
    }

    public JQueryElement first() {
        return this.jquery.first(this, this.webDriver);
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }
}

