/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.factory;

import java.lang.reflect.Field;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.factory.AnnotationProxyFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;

public class Annotations
extends AbstractAnnotations {
    private Field field;
    private VaniContext vaniContext;
    private AnnotationProxyFactory annotationProxyFactory;

    public Annotations(Field field, VaniContext vaniContext) {
        this.field = field;
        this.vaniContext = vaniContext;
        this.annotationProxyFactory = (AnnotationProxyFactory)this.vaniContext.getAppContext().getBean(AnnotationProxyFactory.class);
    }

    public boolean isLookupCached() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By ans = null;
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        if (findBys != null) {
            ans = this.buildByFromFindBys(this.annotationProxyFactory.createProxy(findBys));
        }
        FindAll findAll = this.field.getAnnotation(FindAll.class);
        if (ans == null && findAll != null) {
            ans = this.buildBysFromFindByOneOf(this.annotationProxyFactory.createProxy(findAll));
        }
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (ans == null && findBy != null) {
            ans = this.buildByFromFindBy(this.annotationProxyFactory.createProxy(findBy));
        }
        if (ans == null) {
            ans = this.buildByFromDefault();
        }
        if (ans == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return ans;
    }

    protected Field getField() {
        return this.field;
    }

    protected By buildByFromDefault() {
        return new ByIdOrName(this.field.getName());
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        FindAll findAll = this.field.getAnnotation(FindAll.class);
        FindBy findBy = this.field.getAnnotation(FindBy.class);
        if (findBys != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBy != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findAll != null && findBys != null) {
            throw new IllegalArgumentException("If you use a '@FindAll' annotation, you must not also use a '@FindBys' annotation");
        }
    }
}

