/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.locator;

import java.util.List;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.javascript.JQuery;
import org.markysoft.vani.core.locating.JQueryElement;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class ByJQuery
extends By {
    private String selector;
    private VaniContext vaniContext;
    private JQuery jquery;

    public ByJQuery(String selector, VaniContext vaniContext) {
        this.selector = selector;
        this.vaniContext = vaniContext;
        this.jquery = (JQuery)this.vaniContext.getAppContext().getBean(JQuery.class);
    }

    public WebElement findElement(SearchContext context) {
        if (context instanceof WebElement) {
            WebDriver driver = null;
            if (context instanceof JQueryElement) {
                driver = ((JQueryElement)context).getWebDriver();
                return ((JQueryElement)context).find(this.selector);
            }
            driver = ((RemoteWebElement)context).getWrappedDriver();
            return this.jquery.find(null, (WebElement)context, driver).find(this.selector);
        }
        if (context instanceof WebDriver) {
            return this.find((WebDriver)context);
        }
        throw new IllegalArgumentException("Provided search context '" + context + "' is not supported by jquery locating!");
    }

    public List<WebElement> findElements(SearchContext context) {
        if (context instanceof WebElement) {
            return this.jquery.find(null, (WebElement)context, ((RemoteWebElement)context).getWrappedDriver()).find(this.selector).get();
        }
        if (context instanceof WebDriver) {
            return this.find((WebDriver)context).get();
        }
        throw new IllegalArgumentException("Provided search context '" + context + "' is not supported by jquery locating!");
    }

    public JQueryElement find() {
        return this.jquery.find(null, this.selector);
    }

    public JQueryElement find(WebDriver webDriver) {
        return this.jquery.find(null, this.selector, webDriver);
    }

    public String toString() {
        return "By.jquery: " + this.selector;
    }
}

