/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.page;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.javascript.LinkUtils;
import org.markysoft.vani.core.locating.page.PageCrawler;
import org.markysoft.vani.core.locating.page.PageHandler;
import org.markysoft.vani.core.locating.page.PageHandlerFactory;
import org.markysoft.vani.core.wait.WaitUtil;
import org.openqa.selenium.WebDriver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultPageCrawler
implements PageCrawler {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected Set<String> urlPatterns = new HashSet<String>();
    protected WebDriver webDriver;
    @Autowired
    protected VaniContext vaniContext;
    @Autowired
    protected PageHandlerFactory pageHandlerFactory;
    @Autowired
    protected WaitUtil waitUtil;
    @Autowired
    protected LinkUtils linkUtils;
    @Value(value="${vani.pageCrawler.pageLoadWaitSeconds:1}")
    protected int pageLoadWaitSeconds;
    @Value(value="${vani.pageCrawler.pageLoadAjaxSeconds:1}")
    protected int pageLoadAjaxSeconds;
    protected List<PageHandler> pageHandlers = new ArrayList<PageHandler>();

    @PostConstruct
    public void initializeHandlers() {
        Set handlerClasses = this.vaniContext.getReflections().getTypesAnnotatedWith(org.markysoft.vani.core.annotation.PageHandler.class);
        for (Class handlerClass : handlerClasses) {
            PageHandler handler = this.pageHandlerFactory.create(handlerClass);
            this.urlPatterns.addAll(handler.getUrlPatterns());
            this.pageHandlers.add(handler);
        }
    }

    @Override
    public void start(WebDriver webDriver) {
        this.webDriver = webDriver;
        this.crawl();
    }

    @Override
    public void start() {
        this.webDriver = (WebDriver)this.vaniContext.getAppContext().getBean(WebDriver.class);
        this.crawl();
    }

    protected void crawl() {
        HashSet<String> visitedUrls = new HashSet<String>();
        List<String> urls = this.getApplicableUrls();
        while (!urls.isEmpty()) {
            String url = urls.remove(0);
            if (this.isVisited(url, visitedUrls)) continue;
            visitedUrls.add(this.removeJSessionId(url));
            this.handle(url);
            urls.addAll(this.getApplicableUrls());
        }
    }

    protected void handle(String url) {
        this.logger.debug((Object)("try to open next url '" + url + "'"));
        this.webDriver.get(url);
        this.logger.debug((Object)("wait explicit '" + this.pageLoadWaitSeconds + "' seconds after page changed"));
        this.waitUtil.waitTime(this.pageLoadWaitSeconds * 1000);
        this.logger.debug((Object)("wait max '" + this.pageLoadAjaxSeconds + "' seconds for ajax requests are finished!"));
        this.waitUtil.ajaxJQuery(this.pageLoadAjaxSeconds * 1000, this.webDriver);
        for (PageHandler handler : this.pageHandlers) {
            if (!handler.isApplicable(url)) continue;
            handler.handle(url, this.webDriver);
        }
        this.logger.debug((Object)("handling url '" + url + "' finished"));
    }

    protected boolean isVisited(String url, Set<String> visitedUrls) {
        boolean result = false;
        url = this.removeJSessionId(url);
        result = visitedUrls.contains(url);
        return result;
    }

    protected String removeJSessionId(String url) {
        if (url.toLowerCase().contains(";jsessionid")) {
            String[] parts = url.split("(?i);jsessionid");
            if (parts.length > 1) {
                int idx = parts[1].indexOf("?");
                parts[1] = idx >= 0 ? parts[1].substring(idx) : "";
            }
            StringBuilder builder = new StringBuilder();
            for (String p : parts) {
                builder.append(p);
            }
            url = builder.toString();
        }
        return url;
    }

    protected List<String> getApplicableUrls() {
        this.logger.debug((Object)"look for applicable urls ...");
        List<String> result = this.linkUtils.getApplicableUrls(this.urlPatterns.toArray(new String[0]));
        this.logger.debug((Object)"looking for applicable urls done");
        return result;
    }
}

