/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.wait;

import java.util.concurrent.TimeUnit;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.wait.WaitBuilder;
import org.markysoft.vani.core.wait.WaitOperatorBuilder;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

public class WaitUtil {
    @Autowired
    protected VaniContext vaniContext;

    public WaitOperatorBuilder element(WebElement element) {
        return new WaitBuilder(this.vaniContext).element(element);
    }

    public WaitOperatorBuilder element(String selector) {
        return new WaitBuilder(this.vaniContext).element(selector);
    }

    public WaitOperatorBuilder element(String selector, SearchContext rootElement) {
        return new WaitBuilder(this.vaniContext).element(selector, rootElement);
    }

    public WaitOperatorBuilder webDriver(WebDriver value) {
        return new WaitBuilder(this.vaniContext).webDriver(value);
    }

    public void wait(long millis, WebDriver driver) {
        driver.manage().timeouts().implicitlyWait(millis, TimeUnit.MILLISECONDS);
    }

    public void waitTime(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void ajaxJQuery(long timeoutInMillis, WebDriver webDriver) {
        Long activeAjaxCalls;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < timeoutInMillis && (activeAjaxCalls = (Long)((JavascriptExecutor)webDriver).executeScript("return $.active;", new Object[0])) > 0L) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void ajaxJQuery(long timeoutInMillis, long delayInMillis, WebDriver webDriver) {
        this.waitTime(delayInMillis);
        this.ajaxJQuery(timeoutInMillis, webDriver);
    }

    public void ajaxJQuery(String url, long startInMillis, long timeoutInMillis, WebDriver webDriver) {
        new WaitBuilder(this.vaniContext).ajax(url, startInMillis, webDriver).until(timeoutInMillis, 500L, webDriver);
    }
}

