/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.LocatorBuilderClass;
import org.markysoft.vani.core.locating.FragmentObject;
import org.markysoft.vani.core.locating.LocatorBuilder;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.UnresolvableLocatorException;
import org.markysoft.vani.core.locating.VaniElementLocator;
import org.markysoft.vani.core.locating.factory.Annotations;
import org.markysoft.vani.core.locating.factory.ElementLocatorFactory;
import org.markysoft.vani.core.locating.factory.LocatorBuilderFactory;
import org.markysoft.vani.core.locating.locator.ByJQuery;
import org.markysoft.vani.core.util.ElementInterceptor;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.markysoft.vani.core.util.VaniReflectionUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.FindAll;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ReflectionUtils;

public class LocatorFieldCallback
implements ReflectionUtils.FieldCallback {
    private static Log logger = LogFactory.getLog(LocatorFieldCallback.class);
    private static final List<Class<? extends Annotation>> APPLICABLE_ANNOTATIONS = Arrays.asList(FindBy.class, FindBys.class, FindAll.class);
    private Object bean;
    private VaniContext vaniContext;
    private ElementLocatorFactory elementLocatorFactory;
    private VaniReflectionUtil reflectionUtil;
    protected ConfigurableListableBeanFactory configurableBeanFactory;
    protected LocatorBuilderFactory locatorBuilderFactory;

    public LocatorFieldCallback(ConfigurableListableBeanFactory configurableBeanFactory, Object bean, VaniContext vaniContext) {
        this.configurableBeanFactory = configurableBeanFactory;
        this.bean = bean;
        this.vaniContext = vaniContext;
        this.reflectionUtil = (VaniReflectionUtil)vaniContext.getAppContext().getBean(VaniReflectionUtil.class);
        this.elementLocatorFactory = (ElementLocatorFactory)vaniContext.getAppContext().getBean(ElementLocatorFactory.class);
        this.locatorBuilderFactory = (LocatorBuilderFactory)vaniContext.getAppContext().getBean(LocatorBuilderFactory.class);
    }

    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
        Annotation customLocatorAnnotation;
        Object beanInstance = null;
        for (Class<? extends Annotation> annotationClass : APPLICABLE_ANNOTATIONS) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            beanInstance = this.handle((Annotation)((Object)annotationClass), field);
            break;
        }
        if ((customLocatorAnnotation = this.reflectionUtil.getAnnotatedAnnotation(field, LocatorBuilderClass.class)) != null) {
            beanInstance = this.handle(customLocatorAnnotation, field);
        }
        if (beanInstance != null) {
            ReflectionUtils.makeAccessible((Field)field);
            field.set(this.bean, beanInstance);
        }
    }

    protected <T extends Annotation> Object handle(Class<T> annotationClass, Field field) {
        T annotation = field.getDeclaredAnnotation(annotationClass);
        return this.handle(annotation, field);
    }

    protected <T extends Annotation> Object handle(T annotation, Field field) {
        By by = this.from(annotation, field);
        FieldTypeInfo fieldTypeInfo = this.reflectionUtil.getFieldTypeInfo(field, this.bean);
        boolean shouldCache = field.getAnnotation(CacheLookup.class) != null || by instanceof ByJQuery;
        SearchContext searchContext = this.getSearchContext();
        VaniElementLocator<?> elementLocator = this.elementLocatorFactory.createLocator(fieldTypeInfo, searchContext, by, shouldCache);
        Class type = fieldTypeInfo.getFieldType();
        Object proxy = this.createProxy(type, elementLocator, field);
        return proxy;
    }

    protected SearchContext getSearchContext() {
        WebDriver result = null;
        if (this.bean instanceof RegionObject) {
            result = ((RegionObject)this.bean).getWebDriver();
            if (this.bean instanceof FragmentObject) {
                result = ((FragmentObject)this.bean).getRootElement();
            }
        } else {
            result = (SearchContext)this.vaniContext.getAppContext().getBean(WebDriver.class);
        }
        return result;
    }

    protected <R> R createProxy(Class<?> targetClass, VaniElementLocator elementLocator, Field field) throws UnresolvableLocatorException {
        Object result;
        try {
            result = new ByteBuddy().subclass(targetClass).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)new ElementInterceptor(elementLocator))).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().newInstance();
        }
        catch (Exception ex) {
            throw new UnresolvableLocatorException("cannot resolve locator for class '" + targetClass + "' and field '" + field + "': " + ex, ex);
        }
        return (R)result;
    }

    public <T extends Annotation> By from(T annotation, Field field) {
        LocatorBuilderClass locatorBuilderAnnotation = annotation.annotationType().getDeclaredAnnotation(LocatorBuilderClass.class);
        if (locatorBuilderAnnotation == null) {
            return new Annotations(field, this.vaniContext).buildBy();
        }
        return this.fromCustom(annotation, field, locatorBuilderAnnotation);
    }

    protected <T extends Annotation> By fromCustom(T annotation, Field field, LocatorBuilderClass locatorBuilderAnnotation) {
        By result = null;
        Class<? extends LocatorBuilder> builderClass = locatorBuilderAnnotation.value();
        LocatorBuilder builder = null;
        if (builderClass == null) {
            throw new UnableToLocateException("No LocatorBuilder class specified for annotation '" + annotation + "' of field '" + field + "'");
        }
        builder = this.locatorBuilderFactory.get(builderClass);
        result = (By)builder.build(annotation);
        return result;
    }
}

