/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.javascript;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.annotation.DetectionScript;
import org.markysoft.vani.core.annotation.JavaScriptFunction;
import org.markysoft.vani.core.javascript.JavaScriptCallFunction;
import org.markysoft.vani.core.javascript.JavaScriptException;
import org.markysoft.vani.core.javascript.JavaScriptSource;
import org.openqa.selenium.JavascriptExecutor;
import org.springframework.util.StringUtils;

public class VaniJavaScriptExecutor
implements JavascriptExecutor {
    protected static final String BOUND_CALL = "return %s.apply(%s,arguments);";
    protected static final String CALL = "try{%s}catch(ex){console.log('Failed to execute injected script: '+ex);return '@JS-ERROR: '+ex;}";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected JavascriptExecutor jsExecutor;
    protected JavaScriptSource<?> jsSource;

    public VaniJavaScriptExecutor(JavascriptExecutor jsExecutor, JavaScriptSource<?> jsSource) {
        this.jsExecutor = jsExecutor;
        this.jsSource = jsSource;
    }

    public Object executeScript(String script, Object ... args) {
        return this.doExecute(this.prepareSource(script), args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.doExecuteAsync(this.prepareSource(script), args);
    }

    public Object execute(String methodName, JavaScriptFunction jsFunctionAnnotation, Object ... args) {
        try {
            String callSource = "";
            if (StringUtils.isEmpty((Object)jsFunctionAnnotation.value())) {
                String funcName = "";
                funcName = StringUtils.isEmpty((Object)jsFunctionAnnotation.name()) ? methodName : jsFunctionAnnotation.name();
                callSource = this.getCallSource(funcName);
            } else {
                callSource = jsFunctionAnnotation.value();
            }
            callSource = String.format(CALL, callSource);
            String source = this.prepareSource(callSource);
            return this.doExecute(source, args);
        }
        catch (Exception ex) {
            throw new JavaScriptException("Exception occurred during executing script bound to method '" + methodName + "' of interface '" + this.jsSource.getJsInterface() + "': " + ex.getMessage(), ex);
        }
    }

    protected String getCallSource(String funcName) {
        String result = "";
        if (this.jsSource.getJsCallFunction() == null) {
            result = String.format(BOUND_CALL, funcName, "null");
        } else {
            JavaScriptCallFunction jsCallFunction = this.jsSource.getJsCallFunction();
            StringBuilder callBuilder = new StringBuilder();
            String callFuncVariable = String.format("vaniJsCallFunc_%s", funcName);
            callBuilder.append(String.format("var %s = %s;", callFuncVariable, jsCallFunction.getCallFunctionSource()));
            callBuilder.append(String.format("return %s.apply(null,arguments);", callFuncVariable));
            result = callBuilder.toString();
        }
        return result;
    }

    protected Object doExecute(String script, Object ... args) {
        try {
            return this.handleResult(this.jsExecutor.executeScript(script, args));
        }
        catch (Exception ex) {
            this.logger.debug((Object)("execution failed for script:\n" + script));
            throw ex;
        }
    }

    protected Object doExecuteAsync(String script, Object ... args) throws JavaScriptException {
        try {
            return this.handleResult(this.jsExecutor.executeAsyncScript(script, args));
        }
        catch (Exception ex) {
            this.logger.debug((Object)("execution failed for script:\n" + script));
            throw ex;
        }
    }

    protected Object handleResult(Object result) throws JavaScriptException {
        if (result != null && result instanceof String && ((String)result).startsWith("@JS-ERROR:")) {
            throw new JavaScriptException("Failed to execute injected script: " + result);
        }
        return result;
    }

    protected String prepareSource(String source) throws JavaScriptException {
        StringBuilder sourceBuilder = new StringBuilder();
        this.appendSource(sourceBuilder, this.jsSource, new HashSet());
        if (!StringUtils.isEmpty((Object)source)) {
            sourceBuilder.append(source);
        }
        return sourceBuilder.toString();
    }

    protected void appendSource(StringBuilder builder, JavaScriptSource<?> jsSource, Set<JavaScriptSource<?>> processingSources) throws JavaScriptException {
        if (jsSource != null && !processingSources.contains(jsSource)) {
            processingSources.add(jsSource);
            for (JavaScriptSource<?> dependency : jsSource.getDependencies()) {
                this.appendSource(builder, dependency, processingSources);
            }
            boolean mustInject = false;
            try {
                mustInject = this.mustInject(jsSource);
            }
            catch (Exception ex) {
                throw new JavaScriptException("Cannot execute detection script: " + ex.getMessage(), ex);
            }
            if (mustInject) {
                builder.append(jsSource.getSource());
                builder.append("\n");
            }
            for (JavaScriptSource<?> plugin : jsSource.getPlugins()) {
                this.appendSource(builder, plugin, processingSources);
            }
        }
    }

    protected boolean mustInject(JavaScriptSource<?> jsSource) {
        String detectionScript;
        boolean result = true;
        DetectionScript detectionAnnotation = jsSource.getDetectionScriptAnnotation();
        if (detectionAnnotation != null && !StringUtils.isEmpty((Object)(detectionScript = detectionAnnotation.value()))) {
            String statementPrefix = detectionAnnotation.autoReturn() ? "return " : "";
            String statementPostfix = detectionAnnotation.autoReturn() ? ";" : "";
            result = (Boolean)this.doExecute(String.format("%s%s%s", statementPrefix, detectionScript, statementPostfix), new Object[0]) == false;
        }
        return result;
    }

    public JavascriptExecutor getWrappedExecutor() {
        return this.jsExecutor;
    }
}

