/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.factory;

import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.BaseElementLocator;
import org.markysoft.vani.core.locating.JQueryElement;
import org.markysoft.vani.core.locating.JQueryElementLocator;
import org.markysoft.vani.core.locating.RegionElementLocator;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.VaniElementLocator;
import org.markysoft.vani.core.locating.WebElementLocator;
import org.markysoft.vani.core.locating.factory.ElementLocatorFactory;
import org.markysoft.vani.core.locating.factory.RegionFactory;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultElementLocatorFactory
implements ElementLocatorFactory {
    @Autowired
    protected VaniContext vaniContext;
    @Autowired
    protected RegionFactory regionFactory;

    @Override
    public VaniElementLocator<?> createLocator(FieldTypeInfo fieldTypeInfo, SearchContext searchContext, By by, boolean shouldCache) {
        Class<?> type = fieldTypeInfo.getTargetType();
        BaseElementLocator result = null;
        if (JQueryElement.class.isAssignableFrom(type)) {
            result = new JQueryElementLocator(searchContext, by, shouldCache, fieldTypeInfo, this.vaniContext);
        } else if (WebElement.class.isAssignableFrom(type)) {
            result = new WebElementLocator(searchContext, by, shouldCache, fieldTypeInfo, this.vaniContext);
        } else if (RegionObject.class.isAssignableFrom(type)) {
            result = new RegionElementLocator(searchContext, by, true, fieldTypeInfo, this.regionFactory, this.vaniContext);
        }
        return result;
    }
}

