/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.page;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.PageObject;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.factory.RegionFactory;
import org.markysoft.vani.core.locating.page.PageHandler;
import org.openqa.selenium.WebDriver;

public class DefaultPageHandler<T>
implements PageHandler<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    protected T handler;
    protected Map<Pattern, Method> methodMap;
    protected VaniContext vaniContext;
    protected RegionFactory regionFactory;

    public DefaultPageHandler(T handler, VaniContext vaniContext) {
        this.handler = handler;
        this.methodMap = new HashMap<Pattern, Method>();
        this.vaniContext = vaniContext;
        this.regionFactory = (RegionFactory)vaniContext.getAppContext().getBean(RegionFactory.class);
    }

    protected void setMethodMap(Map<Pattern, Method> methodMap) {
        if (methodMap == null) {
            this.methodMap.clear();
        } else {
            this.methodMap = methodMap;
        }
    }

    @Override
    public boolean isApplicable(String url) {
        boolean result = this.getApplicable(url) != null;
        return result;
    }

    protected Method getApplicable(String url) {
        Method result = null;
        int matching = 0;
        for (Pattern pattern : this.methodMap.keySet()) {
            String group;
            Matcher m = pattern.matcher(url);
            if (!m.find() || (group = m.group()).length() <= matching) continue;
            result = this.methodMap.get(pattern);
            matching = group.length();
        }
        return result;
    }

    @Override
    public void handle(String url, WebDriver webDriver) {
        Method method = this.getApplicable(url);
        if (method != null) {
            ArrayList<String> parameters = new ArrayList<String>();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes != null) {
                boolean urlAdded = false;
                for (Class<?> paramType : parameterTypes) {
                    if (String.class.isAssignableFrom(paramType) && !urlAdded) {
                        parameters.add(url);
                        urlAdded = true;
                        continue;
                    }
                    if (WebDriver.class.isAssignableFrom(paramType)) {
                        parameters.add((String)webDriver);
                        continue;
                    }
                    if (PageObject.class.isAssignableFrom(paramType)) {
                        parameters.add((String)this.regionFactory.createPage(paramType, webDriver, url));
                        continue;
                    }
                    if (RegionObject.class.isAssignableFrom(paramType)) {
                        parameters.add((String)this.regionFactory.create(paramType, webDriver));
                        continue;
                    }
                    this.logger.debug((Object)("No parameter mapping found for type '" + paramType.getSimpleName() + "' for handler method '" + method + "' of target handler '" + this.handler.getClass() + "'!"));
                    parameters.add(null);
                }
            }
            try {
                method.invoke(this.handler, parameters.toArray());
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() != null) {
                    this.logger.error((Object)("Method '" + method + "' of PageHandler '" + this.handler.getClass() + "' throws an exception: " + ex.getCause()), ex.getCause());
                } else {
                    this.logger.error((Object)("Method '" + method + "' of PageHandler '" + this.handler.getClass() + "' throws an exception: " + ex), (Throwable)ex);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Method '" + method + "' of PageHandler '" + this.handler.getClass() + "' throws an exception: " + ex), (Throwable)ex);
            }
        }
    }

    @Override
    public Set<String> getUrlPatterns() {
        HashSet<String> result = new HashSet<String>();
        for (Pattern pattern : this.methodMap.keySet()) {
            result.add(pattern.pattern());
        }
        return result;
    }
}

