/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.factory.AnnotationProxyFactory;
import org.springframework.util.StringUtils;

public class AnnotationInterceptor {
    private Annotation annotation;
    private VaniContext vaniContext;
    private AnnotationProxyFactory annotationProxyFactory;

    public AnnotationInterceptor(Annotation annotation, VaniContext vaniContext, AnnotationProxyFactory annotationProxyFactory) {
        this.vaniContext = vaniContext;
        this.annotation = annotation;
        this.annotationProxyFactory = annotationProxyFactory;
    }

    protected Object resolvePlaceholders(Object value) {
        if (value != null) {
            String expression;
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                Object[] result = new Object[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = this.resolvePlaceholders(Array.get(value, i));
                }
                value = result;
            } else if (value instanceof Annotation) {
                value = this.annotationProxyFactory.createProxy((Annotation)value);
            } else if (value instanceof String && !StringUtils.isEmpty((Object)(expression = value.toString()))) {
                value = this.vaniContext.resolveExpression(expression);
            }
        }
        return value;
    }

    @RuntimeType
    public Object intercept(@AllArguments Object[] arguments, @Origin Method invokedMethod, @Origin Class<?> targetClass) {
        Object result = null;
        try {
            result = invokedMethod.invoke((Object)this.annotation, arguments);
        }
        catch (Exception ex) {
            throw new UnableToLocateException("cannot invoke method (" + invokedMethod + ") of target annotation (" + targetClass + "): ", ex);
        }
        result = this.resolvePlaceholders(result);
        return result;
    }
}

