/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.annotation.JavaScript;
import org.markysoft.vani.core.annotation.JavaScriptDependency;
import org.markysoft.vani.core.annotation.JsTypeHandler;
import org.markysoft.vani.core.javascript.JavaScriptLoader;
import org.markysoft.vani.core.javascript.JavaScriptSource;
import org.markysoft.vani.core.javascript.TypeHandler;
import org.markysoft.vani.core.locating.factory.JavaScriptProxyFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.reflections.Reflections;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class VaniContext {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Reflections reflections;
    private Environment environment;
    private ApplicationContext appContext;
    private ConfigurableListableBeanFactory configurableBeanFactory;
    private JavaScriptLoader jsLoader;
    private JavaScriptProxyFactory jsProxyFactory;
    private Map<Class<?>, TypeHandler> typeHandlerRegistry = new HashMap(6);
    @Value(value="${vani.firefoxDriver.xpi:}")
    private String firefoxDriverXpi;
    @Value(value="${vani.firefoxDriver.binary:}")
    private String firefoxBinary;

    public Reflections getReflections() {
        return this.reflections;
    }

    public void setReflections(Reflections reflections) {
        this.reflections = reflections;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public void setConfigurableBeanFactory(ConfigurableListableBeanFactory configurableBeanFactory) {
        this.configurableBeanFactory = configurableBeanFactory;
    }

    public boolean isProfileEnabled(Profile profileAnnotation) {
        String[] activeProfiles;
        boolean result = false;
        if (profileAnnotation != null && (activeProfiles = this.environment.getActiveProfiles()) != null) {
            List<String> activeProfilesList = Arrays.asList(activeProfiles);
            for (String profile : profileAnnotation.value()) {
                if (!activeProfilesList.contains(profile)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public String resolveExpression(String expr) {
        String result = this.configurableBeanFactory.resolveEmbeddedValue(expr);
        return result;
    }

    public WebDriver createDefaultDriver() {
        if (!StringUtils.isEmpty((Object)this.firefoxDriverXpi)) {
            System.setProperty("webdriver.firefox.driver", this.firefoxDriverXpi);
        }
        if (!StringUtils.isEmpty((Object)this.firefoxBinary)) {
            System.setProperty("webdriver.firefox.bin", this.firefoxBinary);
        }
        FirefoxDriver driver = new FirefoxDriver();
        this.configurableBeanFactory.registerSingleton("firefoxDriver", (Object)driver);
        return driver;
    }

    @PostConstruct
    protected void registerJavaScripts() {
        this.logger.debug((Object)"register js-interfaces...");
        HashMap jsSourceMap = new HashMap(10);
        Set jsClasses = this.reflections.getTypesAnnotatedWith(JavaScript.class);
        this.logger.debug((Object)("found js-interfaces: " + jsClasses));
        if (jsClasses != null) {
            for (Class jsClass : jsClasses) {
                JavaScript jsAnnotation = jsClass.getDeclaredAnnotation(JavaScript.class);
                jsSourceMap.put(jsClass, this.jsLoader.load(jsAnnotation, jsClass, this));
            }
            for (Class jsClass : jsSourceMap.keySet()) {
                Class<?>[] interfaces;
                JavaScriptSource jsSource = (JavaScriptSource)jsSourceMap.get(jsClass);
                JavaScriptDependency dependencyAnnotation = jsClass.getDeclaredAnnotation(JavaScriptDependency.class);
                if (dependencyAnnotation != null && dependencyAnnotation.value() != null) {
                    for (Class<?> cls : dependencyAnnotation.value()) {
                        JavaScriptSource dependency = (JavaScriptSource)jsSourceMap.get(cls);
                        if (dependency == null) continue;
                        jsSource.addDependency(dependency);
                    }
                }
                if ((interfaces = jsClass.getInterfaces()) != null) {
                    for (Class<?> interfaceClass : interfaces) {
                        JavaScriptSource plugin;
                        if (!interfaceClass.isAnnotationPresent(JavaScript.class) || (plugin = (JavaScriptSource)jsSourceMap.get(interfaceClass)) == null) continue;
                        jsSource.addPlugin(plugin);
                    }
                }
                Object jsProxy = this.jsProxyFactory.createProxy(jsSource);
                this.configurableBeanFactory.registerSingleton(StringUtils.uncapitalize((String)jsClass.getSimpleName()), jsProxy);
                this.logger.debug((Object)("register js-interface: " + jsClass));
            }
        }
        this.initJsTypeHandler();
    }

    protected void initJsTypeHandler() {
        Set handlerClasses = this.reflections.getTypesAnnotatedWith(JsTypeHandler.class);
        for (Class handlerClass : handlerClasses) {
            TypeHandler handler = (TypeHandler)this.createBean(handlerClass);
            this.registerTypeHandler(handler);
        }
    }

    public <T> T createBean(Class<T> beanClass) {
        T result = null;
        String beanName = StringUtils.uncapitalize((String)beanClass.getSimpleName());
        Object instance = null;
        this.logger.info((Object)("Creating new bean named '" + beanName + "'."));
        try {
            result = beanClass.newInstance();
        }
        catch (Exception ex) {
            throw new BeanInstantiationException(beanClass, ex.getMessage(), (Throwable)ex);
        }
        instance = this.configurableBeanFactory.initializeBean(result, beanName);
        this.configurableBeanFactory.autowireBeanProperties(instance, 1, true);
        this.logger.info((Object)("Bean named '" + beanName + "' created successfully."));
        return result;
    }

    public void registerTypeHandler(TypeHandler typeHandler) {
        if (typeHandler != null) {
            this.typeHandlerRegistry.put(typeHandler.getTargetType(), typeHandler);
        }
    }

    public <T> TypeHandler<T, ?> getTypeHandlerFor(Class<T> targetType) {
        return this.typeHandlerRegistry.get(targetType);
    }

    @PreDestroy
    public void shutdownWebDrivers() {
        Map webDrivers = this.appContext.getBeansOfType(WebDriver.class);
        for (WebDriver webDriver : webDrivers.values()) {
            try {
                webDriver.quit();
            }
            catch (Exception ex) {
                this.logger.warn((Object)("cannot close webDriver '" + webDriver + "': " + webDriver));
            }
        }
    }

    @Autowired
    public void setJsLoader(JavaScriptLoader jsLoader) {
        this.jsLoader = jsLoader;
    }

    @Autowired
    public void setJsProxyFactory(JavaScriptProxyFactory jsProxyFactory) {
        this.jsProxyFactory = jsProxyFactory;
    }
}

