/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.AjaxWait;
import org.markysoft.vani.core.annotation.ContentWait;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.VaniElementLocator;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.markysoft.vani.core.util.VaniReflectionUtil;
import org.markysoft.vani.core.wait.WaitUtil;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebElement;

public abstract class BaseElementLocator<T>
implements VaniElementLocator<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final SearchContext searchContext;
    protected final boolean shouldCache;
    protected final By by;
    protected T cachedElement;
    protected List<T> cachedElementList;
    protected FieldTypeInfo fieldTypeInfo;
    protected VaniContext vaniContext;
    protected WaitUtil waitUtil;
    protected VaniReflectionUtil reflectionUtil;

    public BaseElementLocator(SearchContext searchContext, By by, boolean shouldCache, FieldTypeInfo fieldTypeInfo, VaniContext vaniContext) {
        this.searchContext = searchContext;
        this.shouldCache = shouldCache;
        this.by = by;
        this.fieldTypeInfo = fieldTypeInfo;
        this.vaniContext = vaniContext;
        this.waitUtil = (WaitUtil)vaniContext.getAppContext().getBean(WaitUtil.class);
    }

    @Override
    public abstract T findElement();

    @Override
    public abstract List<T> findElements();

    protected void executeContentWait() {
        AjaxWait ajaxWait;
        ContentWait contentWait = this.fieldTypeInfo.getContentWait();
        if (contentWait != null) {
            String selector = this.vaniContext.resolveExpression(contentWait.value());
            String condition = this.vaniContext.resolveExpression(contentWait.condition());
            this.waitUtil.element(selector, this.getRootElement()).spel(condition).until(contentWait.timeout(), contentWait.pollingTime(), this.getWebDriver());
        }
        if ((ajaxWait = this.fieldTypeInfo.getAjaxWait()) != null) {
            this.waitUtil.ajaxJQuery(ajaxWait.value(), this.getWebDriver());
        }
    }

    protected SearchContext getRootElement() {
        return this.searchContext;
    }

    protected WebDriver getWebDriver() {
        if (WebDriver.class.isAssignableFrom(this.searchContext.getClass())) {
            return (WebDriver)this.searchContext;
        }
        if (RemoteWebElement.class.isAssignableFrom(this.searchContext.getClass())) {
            return ((RemoteWebElement)this.searchContext).getWrappedDriver();
        }
        return null;
    }

    protected boolean mustRelocateCachedElements() {
        boolean result = false;
        if (this.fieldTypeInfo.getBean() instanceof RegionObject) {
            result = ((RegionObject)this.fieldTypeInfo.getBean()).isInvalidated();
        }
        return result;
    }
}

