/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.BaseElementLocator;
import org.markysoft.vani.core.locating.JQueryElement;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.locator.ByJQuery;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.springframework.util.ReflectionUtils;

public class JQueryElementLocator
extends BaseElementLocator<JQueryElement> {
    public JQueryElementLocator(SearchContext searchContext, By by, boolean shouldCache, FieldTypeInfo fieldTypeInfo, VaniContext vaniContext) {
        super(searchContext, by, shouldCache, fieldTypeInfo, vaniContext);
    }

    @Override
    public JQueryElement findElement() {
        if (this.cachedElement != null && this.shouldCache && !this.mustRelocateCachedElements()) {
            return (JQueryElement)this.cachedElement;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=========> getting jquery element BY\n\t'" + this.by + "' ON searchContext " + this.searchContext));
        }
        this.executeContentWait();
        JQueryElement result = null;
        result = this.by instanceof ByJQuery ? (JQueryElement)this.by.findElement(this.searchContext) : ((JQueryElement)this.searchContext).find(this.resolveSelector());
        if (this.shouldCache) {
            this.cachedElement = result;
        }
        return result;
    }

    @Override
    public List<JQueryElement> findElements() {
        if (this.cachedElementList != null && !this.mustRelocateCachedElements()) {
            return this.cachedElementList;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=========> getting jquery elements BY\n\t'" + this.by + "' ON searchContext " + this.searchContext));
        }
        this.executeContentWait();
        List<Object> elements = new ArrayList();
        elements = this.by instanceof ByJQuery ? this.by.findElements(this.searchContext) : Arrays.asList(((JQueryElement)this.searchContext).find(this.resolveSelector()));
        this.cachedElementList = elements;
        return elements;
    }

    protected String resolveSelector() {
        if (this.by instanceof By.ById) {
            return "#" + this.getSelectorField("id");
        }
        if (this.by instanceof By.ByClassName) {
            return "." + this.getSelectorField("className");
        }
        if (this.by instanceof By.ByCssSelector) {
            return this.getSelectorField("selector");
        }
        if (this.by instanceof By.ByTagName) {
            return this.getSelectorField("name");
        }
        if (this.by instanceof By.ByName) {
            return this.getSelectorField("name");
        }
        throw new UnableToLocateException("Unsupported selector in conjunction with jQuery element: " + this.by.getClass());
    }

    protected String getSelectorField(String name) {
        try {
            Field field = this.by.getClass().getDeclaredField(name);
            ReflectionUtils.makeAccessible((Field)field);
            return (String)field.get(this.by);
        }
        catch (Exception ex) {
            throw new UnableToLocateException("Cannot resolve selector of " + this.by.getClass() + " for converting selenium-selector to jquery one: " + ex.getMessage(), ex);
        }
    }
}

