/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating;

import java.util.ArrayList;
import java.util.List;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.BaseElementLocator;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.factory.RegionFactory;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class RegionElementLocator
extends BaseElementLocator<RegionObject> {
    protected RegionFactory regionFactory;

    public RegionElementLocator(SearchContext searchContext, By by, boolean shouldCache, FieldTypeInfo fieldTypeInfo, RegionFactory regionFactory, VaniContext vaniContext) {
        super(searchContext, by, shouldCache, fieldTypeInfo, vaniContext);
        this.regionFactory = regionFactory;
    }

    @Override
    public RegionObject findElement() {
        if (this.cachedElement != null && this.shouldCache && !this.mustRelocateCachedElements()) {
            return (RegionObject)this.cachedElement;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=========> getting region element BY\n\t'" + this.by + "' ON searchContext " + this.searchContext));
        }
        this.executeContentWait();
        WebElement element = this.searchContext.findElement(this.by);
        RegionObject result = (RegionObject)this.resolve(element);
        if (this.shouldCache) {
            this.cachedElement = result;
        }
        return result;
    }

    @Override
    public List<RegionObject> findElements() {
        List<RegionObject> result;
        if (this.cachedElementList != null && !this.mustRelocateCachedElements()) {
            return this.cachedElementList;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("=========> getting region elements BY\n\t'" + this.by + "' ON searchContext " + this.searchContext));
        }
        this.executeContentWait();
        List elements = this.searchContext.findElements(this.by);
        this.cachedElementList = result = this.resolve(elements);
        return result;
    }

    protected <T> T resolve(WebElement element) {
        Class type = this.fieldTypeInfo.getFieldType();
        Object result = this.regionFactory.create(type, this.fieldTypeInfo.getWebDriver(), element);
        return result;
    }

    protected <T> List<T> resolve(List<WebElement> elements) {
        Class type = this.fieldTypeInfo.getFirstGenericType();
        if (type == null) {
            this.logger.warn((Object)("cannot determine target region type of list without generic type: " + this.fieldTypeInfo.getField() + " of " + this.fieldTypeInfo.getClass()));
            return null;
        }
        ArrayList result = new ArrayList(elements.size());
        for (WebElement element : elements) {
            Object obj = this.regionFactory.create(type, element);
            if (obj == null) continue;
            result.add(obj);
        }
        return result;
    }
}

