/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.locating.LocatorBuilder;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.factory.LocatorBuilderFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.StringUtils;

public class DefaultLocatorBuilderFactory
implements LocatorBuilderFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ConfigurableListableBeanFactory configurableBeanFactory;
    @Autowired
    protected VaniContext vaniContext;

    public DefaultLocatorBuilderFactory(ConfigurableListableBeanFactory bf) {
        this.configurableBeanFactory = bf;
    }

    @Override
    public LocatorBuilder get(Class<? extends LocatorBuilder> builderClass) {
        LocatorBuilder result = null;
        String builderName = StringUtils.uncapitalize((String)builderClass.getSimpleName());
        if (!this.configurableBeanFactory.containsBean(builderName)) {
            try {
                result = this.vaniContext.createBean(builderClass);
                this.configurableBeanFactory.registerSingleton(builderName, (Object)result);
            }
            catch (Exception ex) {
                throw new UnableToLocateException("Cannot create new instance of LocatorBuilder '" + builderClass + "': " + ex, ex);
            }
        } else {
            result = (LocatorBuilder)this.configurableBeanFactory.getBean(builderName);
            this.logger.info((Object)("Bean named '" + builderName + "' already exists used as current bean reference."));
        }
        return result;
    }
}

