/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.ManualJavaScriptInterface;
import org.markysoft.vani.core.javascript.JavaScriptException;
import org.markysoft.vani.core.javascript.JavaScriptSource;
import org.markysoft.vani.core.util.JavaScriptMethodInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class JavaScriptProxyFactory {
    private final Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    protected VaniContext vaniContext;

    public <T> T createProxy(JavaScriptSource<T> jsSource) {
        Class<T> jsInterface = jsSource.getJsInterface();
        T result = null;
        try {
            List<Object> manualJSInterfaceImplementations = this.loadManualJSInterfaceImplementation(jsInterface);
            result = new ByteBuddy().subclass(jsInterface).method((ElementMatcher)ElementMatchers.any()).intercept((Implementation)MethodDelegation.to((Object)new JavaScriptMethodInterceptor(jsSource, this.vaniContext, manualJSInterfaceImplementations))).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().newInstance();
        }
        catch (Exception ex) {
            this.logger.warn((Object)("cannot create proxy for JavaScript interface '" + jsInterface + "': " + ex.getMessage()), (Throwable)ex);
        }
        return result;
    }

    protected List<Object> loadManualJSInterfaceImplementation(Class<?> jsInterface) {
        ArrayList<Object> result = new ArrayList<Object>(4);
        ArrayList superInterfaces = new ArrayList(24);
        superInterfaces.addAll(Arrays.asList(jsInterface.getInterfaces()));
        while (!superInterfaces.isEmpty()) {
            Set manualImplementations;
            Class superInterface = (Class)superInterfaces.remove(0);
            ManualJavaScriptInterface manualJSAnnotation = superInterface.getDeclaredAnnotation(ManualJavaScriptInterface.class);
            if (manualJSAnnotation != null && !(manualImplementations = this.vaniContext.getReflections().getSubTypesOf(superInterface)).isEmpty()) {
                if (manualImplementations.size() > 1) {
                    throw new JavaScriptException("Cannot determine which manual implementation should be used for '" + superInterface + "'!");
                }
                Object instance = this.vaniContext.createBean((Class)manualImplementations.iterator().next());
                result.add(instance);
            }
            superInterfaces.addAll(Arrays.asList(superInterface.getInterfaces()));
        }
        return result;
    }
}

