/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.locating.page;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.UrlMapping;
import org.markysoft.vani.core.locating.page.DefaultPageHandler;
import org.markysoft.vani.core.locating.page.PageHandler;
import org.markysoft.vani.core.locating.page.PageHandlerFactory;
import org.markysoft.vani.core.util.VaniReflectionUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultPageHandlerFactory
implements PageHandlerFactory {
    protected Log logger = LogFactory.getLog(this.getClass());
    @Autowired
    protected VaniContext vaniContext;
    @Autowired
    protected VaniReflectionUtil reflectionUtil;

    @Override
    public <T> PageHandler<T> create(Class<T> handlerClass) {
        T target = this.vaniContext.createBean(handlerClass);
        DefaultPageHandler<T> result = new DefaultPageHandler<T>(target, this.vaniContext);
        Map<Pattern, Method> methodMap = this.getMethodMap(handlerClass);
        result.setMethodMap(methodMap);
        return result;
    }

    protected <T> Map<Pattern, Method> getMethodMap(Class<T> handlerClass) {
        HashMap<Pattern, Method> result = new HashMap<Pattern, Method>();
        String urlPrefix = "";
        UrlMapping urlMapping = handlerClass.getAnnotation(UrlMapping.class);
        if (urlMapping != null) {
            urlPrefix = urlMapping.value();
        }
        List<Method> methods = this.reflectionUtil.getAnnotatedMethodsWith(handlerClass, UrlMapping.class, null);
        for (Method method : methods) {
            urlMapping = method.getAnnotation(UrlMapping.class);
            String url = urlPrefix + urlMapping.value();
            url = this.vaniContext.resolveExpression(url);
            Pattern pattern = Pattern.compile(url);
            result.put(pattern, method);
            this.logger.debug((Object)("[" + url + "] bound to page handler '" + method + "'"));
        }
        return result;
    }
}

