/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.VaniElementLocator;

public class ElementInterceptor {
    private VaniElementLocator<?> elementLocator;

    public ElementInterceptor(VaniElementLocator<?> elementLocator) {
        this.elementLocator = elementLocator;
    }

    private <T> T loadTarget(Class<T> targetClass) {
        List<?> result = null;
        if (!Map.class.isAssignableFrom(targetClass)) {
            result = List.class.isAssignableFrom(targetClass) ? this.elementLocator.findElements() : this.elementLocator.findElement();
        }
        return (T)result;
    }

    @RuntimeType
    public Object intercept(@AllArguments Object[] arguments, @Origin Method invokedMethod, @Origin Class<?> targetClass) {
        Object result = null;
        if (Object.class.equals(targetClass)) {
            targetClass = invokedMethod.getDeclaringClass();
        }
        Object targetObj = this.loadTarget(targetClass);
        try {
            result = invokedMethod.invoke(targetObj, arguments);
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex;
            if (ex.getCause() != null) {
                throwable = ex.getCause();
            }
            throw new UnableToLocateException("cannot invoke method (" + invokedMethod + ") of target object (" + targetClass + "): " + throwable, throwable);
        }
        catch (Exception ex) {
            throw new UnableToLocateException("cannot invoke method (" + invokedMethod + ") of target object (" + targetClass + "): ", ex);
        }
        return result;
    }
}

