/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.GlobalReference;
import org.markysoft.vani.core.annotation.JavaScriptFunction;
import org.markysoft.vani.core.annotation.JsFunctionArguments;
import org.markysoft.vani.core.annotation.JsFunctionName;
import org.markysoft.vani.core.javascript.GlobalReferenceHolder;
import org.markysoft.vani.core.javascript.JavaScriptException;
import org.markysoft.vani.core.javascript.JavaScriptSource;
import org.markysoft.vani.core.javascript.TypeHandler;
import org.markysoft.vani.core.javascript.VaniJavaScriptExecutor;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.springframework.util.StringUtils;

public class JavaScriptMethodInterceptor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private JavaScriptSource<?> jsSource;
    private VaniContext vaniContext;
    private List<Object> manualJSInterfaceImplemenations;

    public JavaScriptMethodInterceptor(JavaScriptSource<?> jsSource, VaniContext vaniContext, List<Object> manualJSInterfaceImplemenations) {
        this.vaniContext = vaniContext;
        this.jsSource = jsSource;
        this.manualJSInterfaceImplemenations = manualJSInterfaceImplemenations;
    }

    @RuntimeType
    public Object intercept(@AllArguments Object[] arguments, @Origin Method invokedMethod, @Origin Class<?> targetClass) {
        Object result = null;
        JavaScriptFunction jsFuncAnnotation = invokedMethod.getDeclaredAnnotation(JavaScriptFunction.class);
        result = jsFuncAnnotation != null ? this.invokeScript(invokedMethod, invokedMethod.getReturnType(), jsFuncAnnotation, arguments) : this.invokeManualImplementation(invokedMethod, new Object[0]);
        return result;
    }

    protected <T> T handleResult(Object result, Class<T> returnType, WebDriver webDriver) {
        TypeHandler<T, ?> typeHandler = this.vaniContext.getTypeHandlerFor(returnType);
        if (typeHandler != null) {
            result = typeHandler.get(result, webDriver);
        }
        return (T)result;
    }

    private Object invokeScript(Method jsMethod, Class<?> returnType, JavaScriptFunction jsFunctionAnnotation, Object[] args) {
        String methodName = jsMethod.getName();
        HashMap filteredArgs = new HashMap(10);
        args = this.filterArguments(jsMethod, args, filteredArgs, JavascriptExecutor.class, GlobalReferenceHolder.class);
        args = this.prepareArgumentsForCustomCallFunc(args, filteredArgs, methodName, jsFunctionAnnotation);
        VaniJavaScriptExecutor executor = this.getExecutor((JavascriptExecutor)filteredArgs.get(JavascriptExecutor.class));
        JavascriptExecutor wrappedExecutor = executor.getWrappedExecutor();
        WebDriver webDriver = null;
        if (wrappedExecutor instanceof WebDriver) {
            webDriver = (WebDriver)wrappedExecutor;
        }
        return this.handleResult(executor.execute(methodName, jsFunctionAnnotation, args), returnType, webDriver);
    }

    protected VaniJavaScriptExecutor getExecutor(JavascriptExecutor jsExecutor) {
        if (jsExecutor == null) {
            jsExecutor = (JavascriptExecutor)this.vaniContext.getAppContext().getBean(WebDriver.class);
        }
        return new VaniJavaScriptExecutor(jsExecutor, this.jsSource);
    }

    protected Object[] filterArguments(Method jsMethod, Object[] arguments, Map<Class<?>, Object> filteredEntries, Class<?> ... filters) {
        Object[] result = arguments;
        if (arguments != null && filters != null) {
            ArrayList<Object> jsArgs = new ArrayList<Object>(arguments.length);
            Class<?>[] parameters = jsMethod.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                Object arg = arguments[i];
                Class<?> param = parameters[i];
                boolean matching = false;
                if (arg == null || !(arg instanceof String)) {
                    Class<?> filterValue = arg == null ? param : arg.getClass();
                    for (Class<?> filter : filters) {
                        if (!filter.isAssignableFrom(filterValue)) continue;
                        filteredEntries.put(filter, arg);
                        matching = true;
                    }
                }
                if (matching) continue;
                jsArgs.add(arg);
            }
            result = jsArgs.toArray();
        }
        return result;
    }

    protected Object[] prepareArgumentsForCustomCallFunc(Object[] arguments, Map<Class<?>, Object> filteredArguments, String jsMethodName, JavaScriptFunction jsFunctionAnnotation) {
        Object[] result = arguments;
        if (this.jsSource.getJsCallFunction() != null) {
            ArrayList<Object> argList = new ArrayList<Object>(5);
            Method callFuncMethod = this.jsSource.getJsCallFunction().getCallMethod();
            Parameter[] params = callFuncMethod.getParameters();
            if (params != null) {
                for (Parameter param : params) {
                    if (param.isAnnotationPresent(GlobalReference.class)) {
                        GlobalReferenceHolder reference = (GlobalReferenceHolder)filteredArguments.get(GlobalReferenceHolder.class);
                        String referenceValue = null;
                        if (reference != null) {
                            referenceValue = reference.getReference();
                        }
                        argList.add(referenceValue);
                        continue;
                    }
                    if (param.isAnnotationPresent(JsFunctionName.class)) {
                        String funcName = null;
                        if (StringUtils.isEmpty((Object)jsFunctionAnnotation.value())) {
                            funcName = StringUtils.isEmpty((Object)jsFunctionAnnotation.name()) ? jsMethodName : jsFunctionAnnotation.name();
                        }
                        argList.add(funcName);
                        continue;
                    }
                    if (!param.isAnnotationPresent(JsFunctionArguments.class)) continue;
                    argList.add(arguments);
                }
            }
            result = argList.toArray();
        }
        return result;
    }

    protected Object invokeManualImplementation(Method method, Object ... arguments) throws JavaScriptException {
        Object result = null;
        for (Object impl : this.manualJSInterfaceImplemenations) {
            try {
                result = method.invoke(impl, arguments);
                break;
            }
            catch (IllegalArgumentException ex) {
                this.logger.debug((Object)("manual implementation '" + impl.getClass() + "' does not have appropriate method '" + method + "':" + ex.getMessage()));
            }
            catch (Exception ex) {
                throw new JavaScriptException("Calling method '" + method + "' of manual implementation '" + impl + "' failed: ", ex);
            }
        }
        return result;
    }
}

