/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.IllegalVaniFieldException;
import org.markysoft.vani.core.util.FieldTypeInfo;
import org.springframework.util.ReflectionUtils;

public class VaniReflectionUtil {
    private final Log logger = LogFactory.getLog(this.getClass());

    public Class<?> getFirstParameterizedType(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        Type listType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        return (Class)listType;
    }

    public Class<?> getElementTargetType(Field field) {
        Class<?> fieldType;
        Class<?> elementTargetType = fieldType = field.getType();
        if (List.class.isAssignableFrom(fieldType)) {
            elementTargetType = this.getFirstParameterizedType(field);
        }
        return elementTargetType;
    }

    public FieldTypeInfo getFieldTypeInfo(Field field, Object bean) {
        Class<?> fieldType = field.getType();
        Class<?> firstGenericType = this.getFirstParameterizedType(field);
        FieldTypeInfo result = new FieldTypeInfo(field, bean, fieldType, firstGenericType);
        return result;
    }

    public Field getField(String name, Class<?> clazz) throws Exception {
        Field field = null;
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            this.logger.debug((Object)("'" + clazz + "' has no field with name '" + name + "'"));
        }
        if (field == null && !clazz.getSuperclass().equals(Object.class)) {
            this.logger.debug((Object)("look in super class '" + clazz.getSuperclass() + "'"));
            field = this.getField(name, clazz.getSuperclass());
        }
        return field;
    }

    public Method getAnnotatedMethodWith(Class<?> targetClass, Class<?> annotation, Class<?> returnType) {
        List<Method> methods = this.getAnnotatedMethodsWith(targetClass, annotation, returnType);
        return methods != null && !methods.isEmpty() ? methods.get(0) : null;
    }

    public List<Method> getAnnotatedMethodsWith(Class<?> targetClass, Class<?> annotation, Class<?> returnType) {
        ArrayList<Method> result = new ArrayList<Method>();
        while (targetClass != null && !Object.class.equals(targetClass)) {
            Method[] methods = targetClass.getDeclaredMethods();
            if (methods != null) {
                for (Method method : methods) {
                    Object assignedAnnotation = method.getAnnotation(annotation);
                    if (assignedAnnotation == null || returnType != null && !returnType.equals(method.getReturnType())) continue;
                    result.add(method);
                }
            }
            targetClass = targetClass.getSuperclass();
        }
        return result;
    }

    public <T extends Annotation> T getTypeAnnotation(Class<T> annotationClazz, Class<?> clazz) {
        T result = null;
        if (clazz.isAnnotationPresent(annotationClazz)) {
            result = clazz.getDeclaredAnnotation(annotationClazz);
        }
        if (result == null && !clazz.getSuperclass().equals(Object.class)) {
            result = this.getTypeAnnotation(annotationClazz, clazz.getSuperclass());
        }
        return result;
    }

    public <T> void setFieldValue(String name, Object bean, T value) throws IllegalVaniFieldException, IllegalAccessException {
        Field field;
        if (bean == null) {
            this.logger.debug((Object)("ignore setting field value for field '" + name + "', because given bean instance is NULL!"));
            return;
        }
        try {
            field = this.getField(name, bean.getClass());
        }
        catch (Exception ex) {
            throw new IllegalVaniFieldException("Target class '" + bean.getClass() + "' has no field '" + name + "' for setting value '" + value + "'!", ex);
        }
        if (field != null) {
            ReflectionUtils.makeAccessible((Field)field);
            field.set(bean, value);
        }
    }

    public Annotation getAnnotatedAnnotation(Field field, Class<? extends Annotation> annotationClass) {
        Annotation result = null;
        Annotation[] annotations = field.getDeclaredAnnotations();
        if (annotations != null) {
            for (Annotation anno : annotations) {
                if (!anno.annotationType().isAnnotationPresent(annotationClass)) continue;
                result = anno;
            }
        }
        return result;
    }

    public boolean hasMethodWithAnnotation(Class<?> targetClass, Class<? extends Annotation> annotationClass) {
        boolean result = this.getAnnotatedMethodWith(targetClass, annotationClass, null) != null;
        return result;
    }
}

