/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.wait;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.javascript.VaniUtils;
import org.markysoft.vani.core.locating.locator.ByJQuery;
import org.markysoft.vani.core.wait.AjaxWaitCommand;
import org.markysoft.vani.core.wait.ByWaitCommand;
import org.markysoft.vani.core.wait.ConjunctionType;
import org.markysoft.vani.core.wait.VariableWaitCommand;
import org.markysoft.vani.core.wait.WaitCommand;
import org.markysoft.vani.core.wait.WaitConditionTargetBuilder;
import org.markysoft.vani.core.wait.WaitOperatorBuilder;
import org.markysoft.vani.core.wait.WebDriverWaitCommand;
import org.markysoft.vani.core.wait.WebElementWaitCommand;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class WaitBuilder
implements WaitOperatorBuilder,
WaitConditionTargetBuilder {
    protected List<WaitCommand> commands = new ArrayList<WaitCommand>(1);
    protected ConjunctionType conjunctionType;
    protected VaniContext vaniContext;
    protected Function<WebDriver, Boolean> evalFunction = new Function<WebDriver, Boolean>(){

        public Boolean apply(WebDriver webDriver) {
            boolean result = true;
            for (WaitCommand cmd : WaitBuilder.this.commands) {
                result &= cmd.eval();
            }
            return result;
        }
    };

    public WaitBuilder(WaitCommand command, VaniContext vaniContext) {
        this.commands.add(command);
        this.vaniContext = vaniContext;
    }

    public WaitBuilder(VaniContext vaniContext) {
        this.vaniContext = vaniContext;
    }

    protected WaitCommand cmd() {
        return this.commands.isEmpty() ? null : this.commands.get(this.commands.size() - 1);
    }

    @Override
    public WaitOperatorBuilder is(Predicate<?> predicate) {
        this.cmd().setConditionPredicate(predicate);
        return this;
    }

    @Override
    public WaitOperatorBuilder is(Supplier<Boolean> supplier) {
        this.cmd().setConditionSupplier(supplier);
        return this;
    }

    @Override
    public WaitOperatorBuilder is(java.util.function.Function<?, Boolean> function) {
        this.cmd().setConditionFunction(function);
        return this;
    }

    @Override
    public WaitOperatorBuilder not() {
        this.cmd().setNotFlag(true);
        return this;
    }

    @Override
    public WaitConditionTargetBuilder and() {
        this.conjunctionType = ConjunctionType.AND;
        return this;
    }

    @Override
    public WaitConditionTargetBuilder or() {
        this.conjunctionType = ConjunctionType.OR;
        return this;
    }

    @Override
    public boolean until(long timeout, long period, WebDriver webDriver) {
        FluentWait wait = new FluentWait((Object)webDriver).withTimeout(timeout, TimeUnit.MILLISECONDS).pollingEvery(period, TimeUnit.MILLISECONDS);
        wait.ignoring(NoSuchElementException.class);
        return (Boolean)wait.until(this.evalFunction);
    }

    @Override
    public boolean until(long timeout, long period) {
        return this.until(timeout, period, null);
    }

    @Override
    public WaitOperatorBuilder element(WebElement element) {
        this.commands.add(new WebElementWaitCommand(element));
        return this;
    }

    @Override
    public WaitOperatorBuilder element(String selector) {
        this.commands.add(new ByWaitCommand(new ByJQuery(selector, this.vaniContext), null));
        return this;
    }

    @Override
    public WaitOperatorBuilder element(String selector, SearchContext rootElement) {
        this.commands.add(new ByWaitCommand(new ByJQuery(selector, this.vaniContext), rootElement));
        return this;
    }

    @Override
    public WaitOperatorBuilder webDriver(WebDriver webDriver) {
        this.commands.add(new WebDriverWaitCommand(webDriver));
        return this;
    }

    public WaitOperatorBuilder ajax(String url, long startInMillis, WebDriver webDriver) {
        this.commands.add(new AjaxWaitCommand(this.vaniContext, url, startInMillis, webDriver));
        return this;
    }

    @Override
    public <T, R> WaitOperatorBuilder has(final java.util.function.Function<T, R> function, final R expected) {
        this.cmd().setConditionPredicate(new Predicate<T>(){

            @Override
            public boolean test(T target) {
                Object actual = function.apply(target);
                boolean result = expected.equals(actual);
                return result;
            }
        });
        return this;
    }

    @Override
    public WaitOperatorBuilder spel(final String condition) {
        this.cmd().setConditionPredicate(new Predicate<WebElement>(){
            ExpressionParser parser = new SpelExpressionParser();
            Expression exp = this.parser.parseExpression(condition);

            @Override
            public boolean test(WebElement element) {
                boolean result = (Boolean)this.exp.getValue((Object)element, Boolean.class);
                return result;
            }
        });
        return this;
    }

    public WaitOperatorBuilder variable(String variableName) {
        this.commands.add(new VariableWaitCommand(variableName, (VaniUtils)this.vaniContext.getAppContext().getBean(VaniUtils.class)));
        return this;
    }
}

