/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.core.wait;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.wait.IllegalWaitCondition;
import org.springframework.util.StringUtils;

public abstract class WaitCommand<T> {
    protected final String UNSUPPORTED_MSG = "'Method not supported by " + this.getClass().getSimpleName() + "'!";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected T target;
    protected boolean notFlag;
    protected Function<T, Boolean> conditionFunction;
    protected Predicate<T> conditionPredicate;
    protected Supplier<Boolean> conditionSupplier;
    protected String message;

    public WaitCommand(T target) {
        this.target = target;
    }

    public void setNotFlag(boolean notFlag) {
        this.notFlag = notFlag;
    }

    public void setConditionFunction(Function<T, Boolean> conditionFunction) {
        this.conditionFunction = conditionFunction;
    }

    public void setConditionPredicate(Predicate<T> conditionPredicate) {
        this.conditionPredicate = conditionPredicate;
    }

    public void setConditionSupplier(Supplier<Boolean> conditionSupplier) {
        this.conditionSupplier = conditionSupplier;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean eval() {
        boolean result;
        block6: {
            result = false;
            try {
                if (this.conditionFunction != null) {
                    result = this.conditionFunction.apply(this.target);
                    break block6;
                }
                if (this.conditionPredicate != null) {
                    result = this.conditionPredicate.test(this.target);
                    break block6;
                }
                if (this.conditionSupplier != null) {
                    result = this.conditionSupplier.get();
                    break block6;
                }
                throw new IllegalWaitCondition("Wait command is not fully configured! No condition found!");
            }
            catch (Exception ex) {
                if (!StringUtils.isEmpty((Object)this.message)) {
                    this.logger.warn((Object)this.message);
                }
                throw ex;
            }
        }
        return result || this.notFlag;
    }
}

