/*
 * Decompiled with CFR 0.152.
 */
package org.markysoft.vani.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.markysoft.vani.core.IllegalVaniFieldException;
import org.markysoft.vani.core.VaniContext;
import org.markysoft.vani.core.annotation.ContentCondition;
import org.markysoft.vani.core.annotation.Page;
import org.markysoft.vani.core.annotation.Xhr;
import org.markysoft.vani.core.locating.FragmentObject;
import org.markysoft.vani.core.locating.JQueryElement;
import org.markysoft.vani.core.locating.PageObject;
import org.markysoft.vani.core.locating.RegionObject;
import org.markysoft.vani.core.locating.UnableToLocateException;
import org.markysoft.vani.core.locating.UnresolvableLocatorException;
import org.markysoft.vani.core.locating.factory.LocatorBuilderFactory;
import org.markysoft.vani.core.locating.factory.RegionFactory;
import org.markysoft.vani.core.locating.locator.ByJQuery;
import org.markysoft.vani.core.locating.locator.FindByJQuery;
import org.markysoft.vani.core.locating.locator.JQueryLocatorBuilder;
import org.markysoft.vani.core.util.VaniReflectionUtil;
import org.markysoft.vani.core.util.XhrInterceptor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class SpringRegionFactory
implements RegionFactory {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableListableBeanFactory configurableBeanFactory;
    @Autowired
    private LocatorBuilderFactory locatorBuilderFactory;
    @Autowired
    protected VaniReflectionUtil reflectionUtil;
    @Autowired
    protected VaniContext vaniContext;

    public SpringRegionFactory(ConfigurableListableBeanFactory bf) {
        this.configurableBeanFactory = bf;
    }

    @Override
    public <T> T create(Class<T> regionClass, WebElement rootElement) {
        return this.create(regionClass, null, null, null, rootElement);
    }

    @Override
    public <T> T create(Class<T> regionClass, WebDriver webDriver, WebElement rootElement) {
        return this.create(regionClass, webDriver, null, null, rootElement);
    }

    @Override
    public <T> T create(Class<T> regionClass, WebDriver webDriver) {
        return this.create(regionClass, webDriver, null, null, null);
    }

    @Override
    public <T> T create(Class<T> regionClass, WebDriver webDriver, Page pageAnnotation) {
        return this.create(regionClass, webDriver, pageAnnotation, null, null);
    }

    @Override
    public <T> T createPage(Class<T> regionClass, WebDriver webDriver, String pageUrl) {
        return this.create(regionClass, webDriver, null, pageUrl, null);
    }

    @Override
    public <T> T create(Class<T> regionClass, Page pageAnnotation) {
        return this.create(regionClass, null, pageAnnotation, null, null);
    }

    public <T> T create(Class<T> regionClass, WebDriver webDriver, Page pageAnnotation, String pageUrl, WebElement rootElement) {
        Class<Object> targetType = regionClass;
        if (List.class.isAssignableFrom(regionClass)) {
            targetType = ArrayList.class;
        }
        if (FragmentObject.class.isAssignableFrom(regionClass)) {
            try {
                targetType = this.resolveFragmentClass(regionClass);
            }
            catch (Exception ex) {
                throw new UnableToLocateException("Cannot determine the fragment type for '" + regionClass + "': " + ex, ex);
            }
        }
        Object result = null;
        if (this.reflectionUtil.hasMethodWithAnnotation(targetType, Xhr.class)) {
            result = this.createProxy(targetType, this.getWebDriver(pageAnnotation, webDriver));
        } else {
            try {
                result = targetType.newInstance();
            }
            catch (Exception ex) {
                throw new UnableToLocateException("Cannot create new instance of region class '" + targetType + "': " + ex, ex);
            }
        }
        try {
            this.injectPreProcessingFields(result, pageAnnotation, pageUrl, webDriver, rootElement);
        }
        catch (Exception ex) {
            throw new UnableToLocateException("Cannot inject basic dependencies to class '" + targetType + "': " + ex, ex);
        }
        String beanName = StringUtils.uncapitalize((String)targetType.getSimpleName());
        result = this.configurableBeanFactory.initializeBean(result, beanName);
        this.configurableBeanFactory.autowireBeanProperties(result, 1, true);
        return (T)result;
    }

    protected <T> void injectPreProcessingFields(T beanInstance, Page pageAnnotation, String pageUrl, WebDriver webDriver, WebElement rootElement) throws IllegalVaniFieldException, IllegalAccessException {
        if (beanInstance instanceof RegionObject) {
            this.reflectionUtil.setFieldValue("vaniContext", beanInstance, this.vaniContext);
        }
        if ((webDriver = this.getWebDriver(pageAnnotation, webDriver)) != null) {
            this.reflectionUtil.setFieldValue("webDriver", beanInstance, webDriver);
        }
        if (pageAnnotation != null && !StringUtils.isEmpty((Object)pageUrl)) {
            pageUrl = pageAnnotation.url();
        }
        if (beanInstance instanceof PageObject && !StringUtils.isEmpty((Object)pageUrl)) {
            this.reflectionUtil.setFieldValue("pageUrl", beanInstance, pageUrl);
        }
        if (beanInstance instanceof FragmentObject) {
            if (rootElement == null) {
                try {
                    rootElement = this.resolveRootElement(beanInstance.getClass(), webDriver);
                }
                catch (Exception ex) {
                    throw new UnableToLocateException("cannot locate root element for class '" + beanInstance.getClass().getName() + "': " + ex.getMessage(), ex);
                }
            }
            if (rootElement != null) {
                try {
                    Field rootElementField = this.reflectionUtil.getField("rootElement", beanInstance.getClass());
                    if (rootElementField != null) {
                        ReflectionUtils.makeAccessible((Field)rootElementField);
                        rootElementField.set(beanInstance, rootElement);
                    }
                }
                catch (Exception ex) {
                    throw new UnableToLocateException("cannot inject root element in class '" + beanInstance.getClass().getName() + "': " + ex.getMessage(), ex);
                }
            }
        }
    }

    protected <T extends FragmentObject> WebElement resolveRootElement(Class<T> regionClass, WebDriver webDriver) {
        JQueryElement result = null;
        FindByJQuery findBy = this.reflectionUtil.getTypeAnnotation(FindByJQuery.class, regionClass);
        if (findBy != null) {
            JQueryLocatorBuilder builder = (JQueryLocatorBuilder)this.locatorBuilderFactory.get(JQueryLocatorBuilder.class);
            ByJQuery by = builder.build(findBy);
            result = by.find(webDriver);
        }
        return result;
    }

    protected <T> Class<? extends T> resolveFragmentClass(Class<T> regionClass) {
        Class result = null;
        Class fallback = null;
        Set subTypes = this.vaniContext.getReflections().getSubTypesOf(regionClass);
        for (Class type : subTypes) {
            if (Modifier.isAbstract(type.getModifiers())) continue;
            ContentCondition contentCondition = type.getAnnotation(ContentCondition.class);
            if (contentCondition == null) {
                fallback = type;
                continue;
            }
            String selector = this.vaniContext.resolveExpression(contentCondition.value());
            ByJQuery by = new ByJQuery(selector, this.vaniContext);
            if (!by.find().hasMatches()) continue;
            result = type;
            break;
        }
        if (result == null && fallback != null) {
            result = fallback;
        }
        if (result == null) {
            result = regionClass;
        }
        return result;
    }

    protected WebDriver getWebDriver(Page pageAnnotation, WebDriver fallbackDriver) {
        String driverBeanName;
        WebDriver result = null;
        if (pageAnnotation != null && !StringUtils.isEmpty((Object)(driverBeanName = pageAnnotation.driverName()))) {
            result = (WebDriver)this.vaniContext.getAppContext().getBean(WebDriver.class, new Object[]{driverBeanName});
        }
        if (result == null) {
            if (fallbackDriver != null) {
                result = fallbackDriver;
            } else {
                try {
                    result = (WebDriver)this.vaniContext.getAppContext().getBean(WebDriver.class);
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.logger.info((Object)"no webDriver found - create default web driver");
                }
            }
            if (result == null) {
                result = this.vaniContext.createDefaultDriver();
            }
        }
        return result;
    }

    protected <R> R createProxy(Class<R> targetClass, WebDriver webDriver) throws UnresolvableLocatorException {
        Object result;
        try {
            result = new ByteBuddy().subclass(targetClass).method((ElementMatcher)ElementMatchers.isAnnotatedWith(Xhr.class)).intercept((Implementation)MethodDelegation.to((Object)new XhrInterceptor(this.vaniContext, webDriver))).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().newInstance();
        }
        catch (Exception ex) {
            throw new UnableToLocateException("cannot instantiate proxy for '" + targetClass + "': " + ex, ex);
        }
        return (R)result;
    }
}

