/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.concurrentlinkedhashmap;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mashupbots.socko.concurrentlinkedhashmap.EntryWeigher;
import org.mashupbots.socko.concurrentlinkedhashmap.EvictionListener;
import org.mashupbots.socko.concurrentlinkedhashmap.GuardedBy;
import org.mashupbots.socko.concurrentlinkedhashmap.Immutable;
import org.mashupbots.socko.concurrentlinkedhashmap.Linked;
import org.mashupbots.socko.concurrentlinkedhashmap.LinkedDeque;
import org.mashupbots.socko.concurrentlinkedhashmap.ThreadSafe;
import org.mashupbots.socko.concurrentlinkedhashmap.Weigher;
import org.mashupbots.socko.concurrentlinkedhashmap.Weighers;

@ThreadSafe
public final class ConcurrentLinkedHashMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentMap<K, V>,
Serializable {
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    static final int BUFFER_THRESHOLD = 16;
    static final int NUMBER_OF_BUFFERS;
    static final int BUFFER_MASK;
    static final int AMORTIZED_DRAIN_THRESHOLD;
    static final Queue<?> DISCARDING_QUEUE;
    final ConcurrentMap<K, Node> data;
    final int concurrencyLevel;
    @GuardedBy(value="evictionLock")
    final LinkedDeque<Node> evictionDeque;
    @GuardedBy(value="evictionLock")
    volatile long weightedSize;
    @GuardedBy(value="evictionLock")
    volatile long capacity;
    volatile int nextOrder;
    @GuardedBy(value="evictionLock")
    int drainedOrder;
    final Lock evictionLock;
    final Queue<Task>[] buffers;
    final AtomicIntegerArray bufferLengths;
    final AtomicReference<DrainStatus> drainStatus;
    final EntryWeigher<? super K, ? super V> weigher;
    final Queue<Node> pendingNotifications;
    final EvictionListener<K, V> listener;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n - 1);
    }

    private ConcurrentLinkedHashMap(Builder<K, V> builder) {
        this.concurrencyLevel = builder.concurrencyLevel;
        this.capacity = Math.min(builder.capacity, 9223372034707292160L);
        this.data = new ConcurrentHashMap<K, Node>(builder.initialCapacity, 0.75f, this.concurrencyLevel);
        this.weigher = builder.weigher;
        this.nextOrder = Integer.MIN_VALUE;
        this.drainedOrder = Integer.MIN_VALUE;
        this.evictionLock = new ReentrantLock();
        this.evictionDeque = new LinkedDeque();
        this.drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
        this.buffers = new Queue[NUMBER_OF_BUFFERS];
        this.bufferLengths = new AtomicIntegerArray(NUMBER_OF_BUFFERS);
        for (int i = 0; i < NUMBER_OF_BUFFERS; ++i) {
            this.buffers[i] = new ConcurrentLinkedQueue<Task>();
        }
        this.listener = builder.listener;
        this.pendingNotifications = this.listener == DiscardingListener.INSTANCE ? DISCARDING_QUEUE : new ConcurrentLinkedQueue();
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    public long capacity() {
        return this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(long l) {
        ConcurrentLinkedHashMap.checkArgument(l >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity = Math.min(l, 9223372034707292160L);
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            this.evict();
        }
        finally {
            this.evictionLock.unlock();
        }
        this.notifyListener();
    }

    boolean hasOverflowed() {
        return this.weightedSize > this.capacity;
    }

    @GuardedBy(value="evictionLock")
    void evict() {
        while (this.hasOverflowed()) {
            Node node = (Node)this.evictionDeque.poll();
            if (node == null) {
                return;
            }
            if (this.data.remove(node.key, node)) {
                this.pendingNotifications.add(node);
            }
            node.makeDead();
        }
    }

    void afterCompletion(Task task) {
        boolean bl = this.schedule(task);
        if (this.shouldDrainBuffers(bl)) {
            this.tryToDrainBuffers(AMORTIZED_DRAIN_THRESHOLD);
        }
        this.notifyListener();
    }

    boolean schedule(Task task) {
        int n = ConcurrentLinkedHashMap.bufferIndex();
        int n2 = this.bufferLengths.incrementAndGet(n);
        if (task.isWrite()) {
            this.buffers[n].add(task);
            this.drainStatus.set(DrainStatus.REQUIRED);
            return false;
        }
        if (n2 <= 0x100000) {
            this.buffers[n].add(task);
            return n2 <= 16;
        }
        this.bufferLengths.decrementAndGet(n);
        return false;
    }

    static int bufferIndex() {
        return (int)Thread.currentThread().getId() & BUFFER_MASK;
    }

    int nextOrdering() {
        return this.nextOrder++;
    }

    boolean shouldDrainBuffers(boolean bl) {
        DrainStatus drainStatus = this.drainStatus.get();
        return drainStatus != DrainStatus.PROCESSING & (!bl | drainStatus == DrainStatus.REQUIRED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryToDrainBuffers(int n) {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.set(DrainStatus.PROCESSING);
                this.drainBuffers(n);
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.PROCESSING, DrainStatus.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    @GuardedBy(value="evictionLock")
    void drainBuffers(int n) {
        Task[] taskArray = new Task[n];
        int n2 = this.moveTasksFromBuffers(taskArray);
        this.runTasks(taskArray, n2);
        this.updateDrainedOrder(taskArray, n2);
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffers(Task[] taskArray) {
        int n = -1;
        for (int i = 0; i < this.buffers.length; ++i) {
            int n2 = this.moveTasksFromBuffer(taskArray, i);
            n = Math.max(n2, n);
        }
        return n;
    }

    @GuardedBy(value="evictionLock")
    int moveTasksFromBuffer(Task[] taskArray, int n) {
        Task task;
        Queue<Task> queue = this.buffers[n];
        int n2 = 0;
        int n3 = -1;
        while ((task = queue.poll()) != null) {
            ++n2;
            int n4 = task.getOrder() - this.drainedOrder;
            if (n4 < 0) {
                task.run();
                continue;
            }
            if (n4 >= taskArray.length) {
                n3 = taskArray.length - 1;
                this.addTaskToChain(taskArray, task, n3);
                break;
            }
            n3 = Math.max(n4, n3);
            this.addTaskToChain(taskArray, task, n4);
        }
        this.bufferLengths.addAndGet(n, -n2);
        return n3;
    }

    @GuardedBy(value="evictionLock")
    void addTaskToChain(Task[] taskArray, Task task, int n) {
        task.setNext(taskArray[n]);
        taskArray[n] = task;
    }

    @GuardedBy(value="evictionLock")
    void runTasks(Task[] taskArray, int n) {
        for (int i = 0; i <= n; ++i) {
            this.runTasksInChain(taskArray[i]);
        }
    }

    @GuardedBy(value="evictionLock")
    void runTasksInChain(Task task) {
        while (task != null) {
            Task task2 = task;
            task = task.getNext();
            task2.setNext(null);
            task2.run();
        }
    }

    @GuardedBy(value="evictionLock")
    void updateDrainedOrder(Task[] taskArray, int n) {
        if (n >= 0) {
            Task task = taskArray[n];
            this.drainedOrder = task.getOrder() + 1;
        }
    }

    void notifyListener() {
        Node node;
        while ((node = this.pendingNotifications.poll()) != null) {
            this.listener.onEviction(node.key, node.getValue());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public long weightedSize() {
        return Math.max(0L, this.weightedSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.evictionLock.lock();
        try {
            Node node;
            while ((node = (Node)this.evictionDeque.poll()) != null) {
                this.data.remove(node.key, node);
                node.makeDead();
            }
            for (int i = 0; i < this.buffers.length; ++i) {
                Task task;
                Queue<Task> queue = this.buffers[i];
                int n = 0;
                while ((task = queue.poll()) != null) {
                    if (task.isWrite()) {
                        task.run();
                    }
                    ++n;
                }
                this.bufferLengths.addAndGet(i, -n);
            }
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        ConcurrentLinkedHashMap.checkNotNull(object);
        for (Node node : this.data.values()) {
            if (!node.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        Node node = (Node)this.data.get(object);
        if (node == null) {
            return null;
        }
        this.afterCompletion(new ReadTask(node));
        return node.getValue();
    }

    public V getQuietly(Object object) {
        Node node = (Node)this.data.get(object);
        return node == null ? null : (V)node.getValue();
    }

    @Override
    public V put(K k, V v) {
        return this.put(k, v, false);
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.put(k, v, true);
    }

    V put(K k, V v, boolean bl) {
        WeightedValue weightedValue;
        Node node;
        ConcurrentLinkedHashMap.checkNotNull(k);
        ConcurrentLinkedHashMap.checkNotNull(v);
        int n = this.weigher.weightOf(k, v);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v, n);
        Node node2 = new Node(k, weightedValue2);
        block0: while (true) {
            if ((node = this.data.putIfAbsent(node2.key, node2)) == null) {
                this.afterCompletion(new AddTask(node2, n));
                return null;
            }
            if (bl) {
                this.afterCompletion(new ReadTask(node));
                return node.getValue();
            }
            do {
                if (!(weightedValue = (WeightedValue)node.get()).isAlive()) continue block0;
            } while (!node.compareAndSet(weightedValue, weightedValue2));
            break;
        }
        int n2 = n - weightedValue.weight;
        ReadTask readTask = n2 == 0 ? new ReadTask(node) : new UpdateTask(node, n2);
        this.afterCompletion(readTask);
        return weightedValue.value;
    }

    @Override
    public V remove(Object object) {
        Node node = (Node)this.data.remove(object);
        if (node == null) {
            return null;
        }
        node.makeRetired();
        this.afterCompletion(new RemovalTask(node));
        return node.getValue();
    }

    @Override
    public boolean remove(Object object, Object object2) {
        Node node = (Node)this.data.get(object);
        if (node == null || object2 == null) {
            return false;
        }
        WeightedValue weightedValue = (WeightedValue)node.get();
        while (weightedValue.hasValue(object2)) {
            if (node.tryToRetire(weightedValue)) {
                if (!this.data.remove(object, node)) break;
                this.afterCompletion(new RemovalTask(node));
                return true;
            }
            weightedValue = (WeightedValue)node.get();
            if (weightedValue.isAlive()) continue;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(k);
        ConcurrentLinkedHashMap.checkNotNull(v);
        int n = this.weigher.weightOf(k, v);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v, n);
        Node node = (Node)this.data.get(k);
        if (node == null) {
            return null;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive()) continue;
            return null;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n2 = n - weightedValue.weight;
        ReadTask readTask = n2 == 0 ? new ReadTask(node) : new UpdateTask(node, n2);
        this.afterCompletion(readTask);
        return weightedValue.value;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        WeightedValue weightedValue;
        ConcurrentLinkedHashMap.checkNotNull(k);
        ConcurrentLinkedHashMap.checkNotNull(v);
        ConcurrentLinkedHashMap.checkNotNull(v2);
        int n = this.weigher.weightOf(k, v2);
        WeightedValue<V> weightedValue2 = new WeightedValue<V>(v2, n);
        Node node = (Node)this.data.get(k);
        if (node == null) {
            return false;
        }
        do {
            if ((weightedValue = (WeightedValue)node.get()).isAlive() && weightedValue.hasValue(v)) continue;
            return false;
        } while (!node.compareAndSet(weightedValue, weightedValue2));
        int n2 = n - weightedValue.weight;
        ReadTask readTask = n2 == 0 ? new ReadTask(node) : new UpdateTask(node, n2);
        this.afterCompletion(readTask);
        return true;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet == null ? (this.keySet = new KeySet()) : keySet;
    }

    public Set<K> ascendingKeySet() {
        return this.orderedKeySet(true, Integer.MAX_VALUE);
    }

    public Set<K> ascendingKeySetWithLimit(int n) {
        return this.orderedKeySet(true, n);
    }

    public Set<K> descendingKeySet() {
        return this.orderedKeySet(false, Integer.MAX_VALUE);
    }

    public Set<K> descendingKeySetWithLimit(int n) {
        return this.orderedKeySet(false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<K> orderedKeySet(boolean bl, int n) {
        ConcurrentLinkedHashMap.checkArgument(n >= 0);
        this.evictionLock.lock();
        try {
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int n2 = this.weigher == Weighers.entrySingleton() ? Math.min(n, (int)this.weightedSize()) : 16;
            LinkedHashSet linkedHashSet = new LinkedHashSet(n2);
            Iterator<Node> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && n > linkedHashSet.size()) {
                linkedHashSet.add(iterator.next().key);
            }
            Set set2 = Collections.unmodifiableSet(linkedHashSet);
            return set2;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    public Map<K, V> ascendingMap() {
        return this.orderedMap(true, Integer.MAX_VALUE);
    }

    public Map<K, V> ascendingMapWithLimit(int n) {
        return this.orderedMap(true, n);
    }

    public Map<K, V> descendingMap() {
        return this.orderedMap(false, Integer.MAX_VALUE);
    }

    public Map<K, V> descendingMapWithLimit(int n) {
        return this.orderedMap(false, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<K, V> orderedMap(boolean bl, int n) {
        ConcurrentLinkedHashMap.checkArgument(n >= 0);
        this.evictionLock.lock();
        try {
            Object object;
            Iterator<Node> iterator;
            this.drainBuffers(AMORTIZED_DRAIN_THRESHOLD);
            int n2 = this.weigher == Weighers.entrySingleton() ? Math.min(n, (int)this.weightedSize()) : 16;
            LinkedHashMap linkedHashMap = new LinkedHashMap(n2);
            Iterator<Node> iterator2 = iterator = bl ? this.evictionDeque.iterator() : this.evictionDeque.descendingIterator();
            while (iterator.hasNext() && n > linkedHashMap.size()) {
                object = iterator.next();
                linkedHashMap.put(((Node)object).key, ((Node)object).getValue());
            }
            object = Collections.unmodifiableMap(linkedHashMap);
            return object;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    static {
        DISCARDING_QUEUE = new DiscardingQueue();
        int n = ConcurrentLinkedHashMap.ceilingNextPowerOfTwo(Runtime.getRuntime().availableProcessors());
        AMORTIZED_DRAIN_THRESHOLD = (1 + n) * 16;
        NUMBER_OF_BUFFERS = n;
        BUFFER_MASK = n - 1;
    }

    public static final class Builder<K, V> {
        static final int DEFAULT_CONCURRENCY_LEVEL = 16;
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        EvictionListener<K, V> listener;
        EntryWeigher<? super K, ? super V> weigher = Weighers.entrySingleton();
        int concurrencyLevel = 16;
        int initialCapacity = 16;
        long capacity = -1L;

        public Builder() {
            this.listener = DiscardingListener.INSTANCE;
        }

        public Builder<K, V> initialCapacity(int n) {
            ConcurrentLinkedHashMap.checkArgument(n >= 0);
            this.initialCapacity = n;
            return this;
        }

        public Builder<K, V> maximumWeightedCapacity(long l) {
            ConcurrentLinkedHashMap.checkArgument(l >= 0L);
            this.capacity = l;
            return this;
        }

        public Builder<K, V> concurrencyLevel(int n) {
            ConcurrentLinkedHashMap.checkArgument(n > 0);
            this.concurrencyLevel = n;
            return this;
        }

        public Builder<K, V> listener(EvictionListener<K, V> evictionListener) {
            ConcurrentLinkedHashMap.checkNotNull(evictionListener);
            this.listener = evictionListener;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super V> weigher) {
            this.weigher = weigher == Weighers.singleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher(Weighers.asEntryWeigher(weigher));
            return this;
        }

        public Builder<K, V> weigher(EntryWeigher<? super K, ? super V> entryWeigher) {
            this.weigher = entryWeigher == Weighers.entrySingleton() ? Weighers.entrySingleton() : new BoundedEntryWeigher<K, V>(entryWeigher);
            return this;
        }

        public ConcurrentLinkedHashMap<K, V> build() {
            ConcurrentLinkedHashMap.checkState(this.capacity >= 0L);
            return new ConcurrentLinkedHashMap(this);
        }
    }

    static final class SerializationProxy<K, V>
    implements Serializable {
        final EntryWeigher<? super K, ? super V> weigher;
        final EvictionListener<K, V> listener;
        final int concurrencyLevel;
        final Map<K, V> data;
        final long capacity;
        static final long serialVersionUID = 1L;

        SerializationProxy(ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap) {
            this.concurrencyLevel = concurrentLinkedHashMap.concurrencyLevel;
            this.data = new HashMap<K, V>(concurrentLinkedHashMap);
            this.capacity = concurrentLinkedHashMap.capacity;
            this.listener = concurrentLinkedHashMap.listener;
            this.weigher = concurrentLinkedHashMap.weigher;
        }

        Object readResolve() {
            ConcurrentLinkedHashMap<K, V> concurrentLinkedHashMap = new Builder().concurrencyLevel(this.concurrencyLevel).maximumWeightedCapacity(this.capacity).listener(this.listener).weigher(this.weigher).build();
            concurrentLinkedHashMap.putAll(this.data);
            return concurrentLinkedHashMap;
        }
    }

    abstract class AbstractTask
    implements Task {
        final int order;
        Task task;

        AbstractTask() {
            this.order = ConcurrentLinkedHashMap.this.nextOrdering();
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public Task getNext() {
            return this.task;
        }

        @Override
        public void setNext(Task task) {
            this.task = task;
        }
    }

    static interface Task
    extends Runnable {
        public int getOrder();

        public boolean isWrite();

        public Task getNext();

        public void setNext(Task var1);
    }

    static enum DiscardingListener implements EvictionListener<Object, Object>
    {
        INSTANCE;


        @Override
        public void onEviction(Object object, Object object2) {
        }
    }

    static final class DiscardingQueue
    extends AbstractQueue<Object> {
        DiscardingQueue() {
        }

        @Override
        public boolean add(Object object) {
            return true;
        }

        @Override
        public boolean offer(Object object) {
            return true;
        }

        @Override
        public Object poll() {
            return null;
        }

        @Override
        public Object peek() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    static final class BoundedEntryWeigher<K, V>
    implements EntryWeigher<K, V>,
    Serializable {
        static final long serialVersionUID = 1L;
        final EntryWeigher<? super K, ? super V> weigher;

        BoundedEntryWeigher(EntryWeigher<? super K, ? super V> entryWeigher) {
            ConcurrentLinkedHashMap.checkNotNull(entryWeigher);
            this.weigher = entryWeigher;
        }

        @Override
        public int weightOf(K k, V v) {
            int n = this.weigher.weightOf(k, v);
            ConcurrentLinkedHashMap.checkArgument(n >= 1);
            return n;
        }

        Object writeReplace() {
            return this.weigher;
        }
    }

    final class WriteThroughEntry
    extends AbstractMap.SimpleEntry<K, V> {
        static final long serialVersionUID = 1L;

        WriteThroughEntry(Node node) {
            super(node.key, node.getValue());
        }

        @Override
        public V setValue(V v) {
            ConcurrentLinkedHashMap.this.put(this.getKey(), v);
            return super.setValue(v);
        }

        Object writeReplace() {
            return new AbstractMap.SimpleEntry(this);
        }
    }

    final class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        final Iterator<Node> iterator;
        Node current;

        EntryIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return new WriteThroughEntry(this.current);
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        final ConcurrentLinkedHashMap<K, V> map;

        EntrySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Node node = (Node)this.map.data.get(entry.getKey());
            return node != null && node.getValue().equals(entry.getValue());
        }

        @Override
        public boolean add(Map.Entry<K, V> entry) {
            return this.map.putIfAbsent(entry.getKey(), entry.getValue()) == null;
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.map.remove(entry.getKey(), entry.getValue());
        }
    }

    final class ValueIterator
    implements Iterator<V> {
        final Iterator<Node> iterator;
        Node current;

        ValueIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public V next() {
            this.current = this.iterator.next();
            return this.current.getValue();
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current.key);
            this.current = null;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public int size() {
            return ConcurrentLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            ConcurrentLinkedHashMap.this.clear();
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsValue(object);
        }
    }

    final class KeyIterator
    implements Iterator<K> {
        final Iterator<K> iterator;
        K current;

        KeyIterator() {
            this.iterator = ConcurrentLinkedHashMap.this.data.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public K next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            ConcurrentLinkedHashMap.checkState(this.current != null);
            ConcurrentLinkedHashMap.this.remove(this.current);
            this.current = null;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        final ConcurrentLinkedHashMap<K, V> map;

        KeySet() {
            this.map = ConcurrentLinkedHashMap.this;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object object) {
            return ConcurrentLinkedHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return this.map.remove(object) != null;
        }

        @Override
        public Object[] toArray() {
            return this.map.data.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.map.data.keySet().toArray(TArray);
        }
    }

    final class Node
    extends AtomicReference<WeightedValue<V>>
    implements Linked<Node> {
        final K key;
        @GuardedBy(value="evictionLock")
        Node prev;
        @GuardedBy(value="evictionLock")
        Node next;

        Node(K k, WeightedValue<V> weightedValue) {
            super(weightedValue);
            this.key = k;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getPrevious() {
            return this.prev;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setPrevious(Node node) {
            this.prev = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public Node getNext() {
            return this.next;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void setNext(Node node) {
            this.next = node;
        }

        V getValue() {
            return ((WeightedValue)this.get()).value;
        }

        boolean tryToRetire(WeightedValue<V> weightedValue) {
            if (weightedValue.isAlive()) {
                WeightedValue weightedValue2 = new WeightedValue(weightedValue.value, -weightedValue.weight);
                return this.compareAndSet(weightedValue, weightedValue2);
            }
            return false;
        }

        void makeRetired() {
            WeightedValue weightedValue;
            WeightedValue weightedValue2;
            do {
                if ((weightedValue2 = (WeightedValue)this.get()).isAlive()) continue;
                return;
            } while (!this.compareAndSet(weightedValue2, weightedValue = new WeightedValue(weightedValue2.value, -weightedValue2.weight)));
        }

        @GuardedBy(value="evictionLock")
        void makeDead() {
            WeightedValue weightedValue;
            WeightedValue weightedValue2;
            while (!this.compareAndSet(weightedValue2 = (WeightedValue)this.get(), weightedValue = new WeightedValue(weightedValue2.value, 0))) {
            }
            ConcurrentLinkedHashMap.this.weightedSize -= (long)Math.abs(weightedValue2.weight);
        }
    }

    @Immutable
    static final class WeightedValue<V> {
        final int weight;
        final V value;

        WeightedValue(V v, int n) {
            this.weight = n;
            this.value = v;
        }

        boolean hasValue(Object object) {
            return object == this.value || this.value.equals(object);
        }

        boolean isAlive() {
            return this.weight > 0;
        }

        boolean isRetired() {
            return this.weight < 0;
        }

        boolean isDead() {
            return this.weight == 0;
        }
    }

    final class UpdateTask
    extends ReadTask {
        final int weightDifference;

        public UpdateTask(Node node, int n) {
            super(node);
            this.weightDifference = n;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            super.run();
            ConcurrentLinkedHashMap.this.weightedSize += (long)this.weightDifference;
            ConcurrentLinkedHashMap.this.evict();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    final class RemovalTask
    extends AbstractTask {
        final Node node;

        RemovalTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.evictionDeque.remove(this.node);
            this.node.makeDead();
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    final class AddTask
    extends AbstractTask {
        final Node node;
        final int weight;

        AddTask(Node node, int n) {
            this.weight = n;
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            ConcurrentLinkedHashMap.this.weightedSize += (long)this.weight;
            if (((WeightedValue)this.node.get()).isAlive()) {
                ConcurrentLinkedHashMap.this.evictionDeque.add(this.node);
                ConcurrentLinkedHashMap.this.evict();
            }
        }

        @Override
        public boolean isWrite() {
            return true;
        }
    }

    class ReadTask
    extends AbstractTask {
        final Node node;

        ReadTask(Node node) {
            this.node = node;
        }

        @Override
        @GuardedBy(value="evictionLock")
        public void run() {
            if (ConcurrentLinkedHashMap.this.evictionDeque.contains(this.node)) {
                ConcurrentLinkedHashMap.this.evictionDeque.moveToBack(this.node);
            }
        }

        @Override
        public boolean isWrite() {
            return false;
        }
    }

    static enum DrainStatus {
        IDLE,
        REQUIRED,
        PROCESSING;

    }
}

