/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.infrastructure;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.mashupbots.socko.infrastructure.CharsetUtil$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.EmptyMethodCache;
import scala.runtime.MethodCache;
import scala.runtime.ScalaRunTime$;

public final class IOUtil$ {
    public static final IOUtil$ MODULE$;
    private static Class[] reflParams$Cache1;
    private static volatile SoftReference reflPoly$Cache1;

    static {
        reflParams$Cache1 = new Class[0];
        reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        new IOUtil$();
    }

    public static Method reflMethod$Method1(Class x$1) {
        Method method1;
        if ((MethodCache)reflPoly$Cache1.get() == null) {
            reflPoly$Cache1 = new SoftReference<EmptyMethodCache>(new EmptyMethodCache());
        }
        if ((method1 = ((MethodCache)reflPoly$Cache1.get()).find(x$1)) == null) {
            method1 = ScalaRunTime$.MODULE$.ensureAccessible(x$1.getMethod("close", reflParams$Cache1));
            reflPoly$Cache1 = new SoftReference<MethodCache>(((MethodCache)reflPoly$Cache1.get()).add(x$1, method1));
            return method1;
        }
        return method1;
    }

    public byte[] readInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[4096];
            while (is.available() > 0) {
                int bytesRead = is.read(buffer);
                baos.write(buffer, 0, bytesRead);
            }
            is.close();
            return baos.toByteArray();
        }
        finally {
            baos.close();
        }
    }

    public void pipe(InputStream bytesIn, OutputStream bytesOut) {
        byte[] buf = new byte[8192];
        this.doPipe$1(bytesIn, bytesOut, buf);
    }

    public byte[] readFile(String filePath) {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(filePath));
        return this.readInputStream(is);
    }

    public byte[] readFile(File file) {
        return this.readFile(file.getAbsolutePath());
    }

    public byte[] readResource(String classpath) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(classpath);
        return this.readInputStream(is);
    }

    public File writeTextFile(File file, String text, Charset charset) {
        this.using((Object)new FileOutputStream(file), (Function1)new Serializable(text, charset){
            public static final long serialVersionUID = 0L;
            private final String text$1;
            private final Charset charset$1;

            public final void apply(FileOutputStream out) {
                out.write(this.text$1.getBytes(this.charset$1));
            }
            {
                this.text$1 = text$1;
                this.charset$1 = charset$1;
            }
        });
        return file;
    }

    public Charset writeTextFile$default$3() {
        return CharsetUtil$.MODULE$.UTF_8();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, A> A using(T resource, Function1<T, A> block) {
        Object object;
        try {
            object = block.apply(resource);
            if (resource == null) return (A)object;
        }
        catch (Throwable throwable) {
            if (resource == null) throw throwable;
            try {
                IOUtil$.reflMethod$Method1(resource.getClass()).invoke(resource, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw invocationTargetException.getCause();
            }
            throw throwable;
        }
        try {
            IOUtil$.reflMethod$Method1(resource.getClass()).invoke(resource, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
        return (A)object;
    }

    /*
     * WARNING - void declaration
     */
    public File createTempDir(String namePrefix) {
        void var2_2;
        File d = File.createTempFile(namePrefix, "");
        d.delete();
        d.mkdir();
        return var2_2;
    }

    public void deleteDir(File dir) {
        if (dir.exists()) {
            File[] files = dir.listFiles();
            Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(File f) {
                    Boolean bl;
                    if (f.isFile()) {
                        bl = BoxesRunTime.boxToBoolean((boolean)f.delete());
                    } else {
                        IOUtil$.MODULE$.deleteDir(f);
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                }
            });
        }
        dir.delete();
    }

    public void deleteDirContents(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            Predef$.MODULE$.refArrayOps((Object[])files).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Object apply(File f) {
                    Boolean bl;
                    if (f.isFile()) {
                        bl = BoxesRunTime.boxToBoolean((boolean)f.delete());
                    } else {
                        IOUtil$.MODULE$.deleteDir(f);
                        bl = BoxedUnit.UNIT;
                    }
                    return bl;
                }
            });
        }
    }

    public boolean isAbsolutePath(String path) {
        return path.startsWith(File.separator) || path.matches("[A-Za-z]:\\\\.*");
    }

    private final void doPipe$1(InputStream bytesIn$1, OutputStream bytesOut$1, byte[] buf$1) {
        int len;
        while ((len = bytesIn$1.read(buf$1)) > 0) {
            bytesOut$1.write(buf$1, 0, len);
        }
    }

    private IOUtil$() {
        MODULE$ = this;
    }
}

