/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.util.CharsetUtil;
import org.mashupbots.socko.events.HttpChunkEvent;
import org.mashupbots.socko.events.HttpEventConfig;
import org.mashupbots.socko.events.HttpRequestEvent;
import org.mashupbots.socko.events.InitialHttpRequestMessage;
import org.mashupbots.socko.events.WebSocketEventConfig;
import org.mashupbots.socko.events.WebSocketFrameEvent;
import org.mashupbots.socko.events.WebSocketHandshakeEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Me\u0001B\u0001\u0003\u0001-\u0011aBU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0006\t\u0003\u001bQi\u0011A\u0004\u0006\u0003\u001fA\tqa\u00195b]:,GN\u0003\u0002\u0012%\u0005)a.\u001a;us*\u00111\u0003C\u0001\u0006U\n|7o]\u0005\u0003+9\u0011AdU5na2,7\t[1o]\u0016dW\u000b]:ue\u0016\fW\u000eS1oI2,'\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u0005q\u0011N\u001c4sCN$(/^2ukJ,\u0017BA\u000e\u0019\u0005\u0019aunZ4fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0004tKJ4XM\u001d\t\u0003?\u0001j\u0011AA\u0005\u0003C\t\u0011\u0011bV3c'\u0016\u0014h/\u001a:\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\t)c\u0005\u0005\u0002 \u0001!)QD\ta\u0001=!9\u0001\u0006\u0001a\u0001\n\u0013I\u0013\u0001D<t\u0011\u0006tGm\u001d5bW\u0016\u0014X#\u0001\u0016\u0011\u0005-\"T\"\u0001\u0017\u000b\u00055r\u0013AC<fEN|7m[3uq*\u0011q\u0006M\u0001\u0005QR$\bO\u0003\u00022e\u0005)1m\u001c3fG*\u00111\u0007E\u0001\bQ\u0006tG\r\\3s\u0013\t)DFA\rXK\n\u001cvnY6fiN+'O^3s\u0011\u0006tGm\u001d5bW\u0016\u0014\bbB\u001c\u0001\u0001\u0004%I\u0001O\u0001\u0011oND\u0015M\u001c3tQ\u0006\\WM]0%KF$\"!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001Z\n\t\u00111\u0001+\u0003\rAH%\r\u0005\u0007\u0005\u0002\u0001\u000b\u0015\u0002\u0016\u0002\u001b]\u001c\b*\u00198eg\"\f7.\u001a:!\u0011\u001d!\u0005\u00011A\u0005\n\u0015\u000b!#\u001b8ji&\fG\u000e\u0013;uaJ+\u0017/^3tiV\ta\tE\u0002;\u000f&K!\u0001S\u001e\u0003\r=\u0003H/[8o!\tQU*D\u0001L\u0015\taE!\u0001\u0004fm\u0016tGo]\u0005\u0003\u001d.\u0013\u0011$\u00138ji&\fG\u000e\u0013;uaJ+\u0017/^3ti6+7o]1hK\"9\u0001\u000b\u0001a\u0001\n\u0013\t\u0016AF5oSRL\u0017\r\u001c%uiB\u0014V-];fgR|F%Z9\u0015\u0005e\u0012\u0006b\u0002!P\u0003\u0003\u0005\rA\u0012\u0005\u0007)\u0002\u0001\u000b\u0015\u0002$\u0002'%t\u0017\u000e^5bY\"#H\u000f\u001d*fcV,7\u000f\u001e\u0011\t\u000fY\u0003!\u0019!C\u0005/\u0006Q\u0001\u000e\u001e;q\u0007>tg-[4\u0016\u0003a\u0003\"AS-\n\u0005i[%a\u0004%uiB,e/\u001a8u\u0007>tg-[4\t\rq\u0003\u0001\u0015!\u0003Y\u0003-AG\u000f\u001e9D_:4\u0017n\u001a\u0011\t\u0011y\u0003\u0001R1A\u0005\n}\u000b\u0001b^:D_:4\u0017nZ\u000b\u0002AB\u0011!*Y\u0005\u0003E.\u0013AcV3c'>\u001c7.\u001a;Fm\u0016tGoQ8oM&<\u0007\u0002\u00033\u0001\u0011\u0003\u0005\u000b\u0015\u00021\u0002\u0013]\u001c8i\u001c8gS\u001e\u0004\u0003\"\u00024\u0001\t\u0003:\u0017aD7fgN\fw-\u001a*fG\u0016Lg/\u001a3\u0015\u0007eBW\u000eC\u0003jK\u0002\u0007!.A\u0002dib\u0004\"!D6\n\u00051t!!F\"iC:tW\r\u001c%b]\u0012dWM]\"p]R,\u0007\u0010\u001e\u0005\u0006]\u0016\u0004\ra\\\u0001\u0002KB\u0011Q\u0002]\u0005\u0003c:\u0011A\"T3tg\u0006<W-\u0012<f]RDQa\u001d\u0001\u0005\nQ\f!C^1mS\u0012\fG/\u001a$jeN$8\t[;oWR\u0011\u0011(\u001e\u0005\u0006mJ\u0004\ra^\u0001\u0006KZ,g\u000e\u001e\t\u0003\u0015bL!!_&\u0003!!#H\u000f\u001d*fcV,7\u000f^#wK:$\b\"B>\u0001\t\u0013a\u0018!\u0005<bY&$\u0017\r^3MCN$8\t[;oWR\u0011\u0011( \u0005\u0006mj\u0004\rA \t\u0003\u0015~L1!!\u0001L\u00059AE\u000f\u001e9DQVt7.\u0012<f]RDq!!\u0002\u0001\t\u0003\n9!A\bfq\u000e,\u0007\u000f^5p]\u000e\u000bWo\u001a5u)\u0015I\u0014\u0011BA\u0006\u0011\u0019I\u00171\u0001a\u0001U\"9a.a\u0001A\u0002\u00055\u0001cA\u0007\u0002\u0010%\u0019\u0011\u0011\u0003\b\u0003\u001d\u0015C8-\u001a9uS>tWI^3oi\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0011AE<sSR,WI\u001d:peJ+7\u000f]8og\u0016$r!OA\r\u00037\t9\u0003\u0003\u0004j\u0003'\u0001\rA\u001b\u0005\t\u0003;\t\u0019\u00021\u0001\u0002 \u000511\u000f^1ukN\u0004B!!\t\u0002$5\ta&C\u0002\u0002&9\u0012!\u0003\u0013;uaJ+7\u000f]8og\u0016\u001cF/\u0019;vg\"A\u0011\u0011FA\n\u0001\u0004\tY#\u0001\u0002fqB!\u0011QFA\u001f\u001d\u0011\ty#!\u000f\u000f\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000e\u000b\u0003\u0019a$o\\8u}%\tA(C\u0002\u0002<m\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0005\u0005#!\u0003+ie><\u0018M\u00197f\u0015\r\tYd\u000f\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003-\u0019\u0007.\u00198oK2|\u0005/\u001a8\u0015\u000be\nI%a\u0013\t\r%\f\u0019\u00051\u0001k\u0011\u001dq\u00171\ta\u0001\u0003\u001b\u00022!DA(\u0013\r\t\tF\u0004\u0002\u0012\u0007\"\fgN\\3m'R\fG/Z#wK:$\bbBA+\u0001\u0011%\u0011qK\u0001\u0018GJ,\u0017\r^3XK\n\u001cvnY6fi2{7-\u0019;j_:$B!!\u0017\u0002hA!\u00111LA1\u001d\rQ\u0014QL\u0005\u0004\u0003?Z\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`mBq![A*\u0001\u0004\tI\u0007E\u0002K\u0003WJ1!!\u001cL\u0005]9VMY*pG.,G\u000fS1oIND\u0017m[3Fm\u0016tG\u000fC\u0004\u0002r\u0001!I!a\u001d\u0002)\u0011|w+\u001a2T_\u000e\\W\r\u001e%b]\u0012\u001c\b.Y6f)\rI\u0014Q\u000f\u0005\bm\u0006=\u0004\u0019AA5\u0011\u001d\tI\b\u0001C\u0005\u0003w\nq\"[:T'2\u001buN\u001c8fGRLwN\u001c\u000b\u0005\u0003{\n\u0019\tE\u0002;\u0003\u007fJ1!!!<\u0005\u001d\u0011un\u001c7fC:DqaDA<\u0001\u0004\t)\tE\u0002\u000e\u0003\u000fK1!!#\u000f\u0005\u001d\u0019\u0005.\u00198oK2Dq!!$\u0001\t\u0013\ty)\u0001\njg\u0006;wM]3bi&twm\u00115v].\u001cH\u0003BA?\u0003#CqaDAF\u0001\u0004\t)\t")
public class RequestHandler
extends SimpleChannelUpstreamHandler
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private WebSocketServerHandshaker wsHandshaker;
    private Option<InitialHttpRequestMessage> initialHttpRequest;
    private final HttpEventConfig httpConfig;
    private WebSocketEventConfig wsConfig;
    private final Logger log;
    private volatile byte bitmap$0;

    private WebSocketEventConfig wsConfig$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wsConfig = new WebSocketEventConfig(this.server.config().serverName(), this.server.webLogWriter());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.wsConfig;
        }
    }

    private Logger log$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.log$lzycompute() : this.log;
    }

    private WebSocketServerHandshaker wsHandshaker() {
        return this.wsHandshaker;
    }

    private void wsHandshaker_$eq(WebSocketServerHandshaker x$1) {
        this.wsHandshaker = x$1;
    }

    private Option<InitialHttpRequestMessage> initialHttpRequest() {
        return this.initialHttpRequest;
    }

    private void initialHttpRequest_$eq(Option<InitialHttpRequestMessage> x$1) {
        this.initialHttpRequest = x$1;
    }

    private HttpEventConfig httpConfig() {
        return this.httpConfig;
    }

    private WebSocketEventConfig wsConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wsConfig$lzycompute() : this.wsConfig;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        block16: {
            block14: {
                Object object;
                block15: {
                    block13: {
                        object = e.getMessage();
                        if (!(object instanceof HttpRequest)) break block13;
                        HttpRequest x2 = (HttpRequest)object;
                        HttpRequestEvent event = new HttpRequestEvent(e.getChannel(), x2, this.httpConfig());
                        this.log().debug("HTTP {} CHANNEL={} {}", new Object[]{event.endPoint(), e.getChannel().getId(), ""});
                        if (event.request().isChunked()) {
                            this.validateFirstChunk(event);
                            this.server.routes().apply((Object)event);
                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                        } else if (event.request().isWebSocketUpgrade()) {
                            WebSocketHandshakeEvent wsctx = new WebSocketHandshakeEvent(e.getChannel(), x2, this.httpConfig());
                            this.server.routes().apply((Object)wsctx);
                            this.doWebSocketHandshake(wsctx);
                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                        } else {
                            this.server.routes().apply((Object)event);
                        }
                        break block14;
                    }
                    if (!(object instanceof HttpChunk)) break block15;
                    HttpChunk x3 = (HttpChunk)object;
                    HttpChunkEvent event = new HttpChunkEvent(e.getChannel(), (InitialHttpRequestMessage)this.initialHttpRequest().get(), x3, this.httpConfig());
                    InitialHttpRequestMessage initialHttpRequestMessage = (InitialHttpRequestMessage)this.initialHttpRequest().get();
                    initialHttpRequestMessage.totalChunkContentLength_$eq(initialHttpRequestMessage.totalChunkContentLength() + (long)x3.getContent().readableBytes());
                    this.log().debug("CHUNK {} CHANNEL={} {}", new Object[]{event.endPoint(), e.getChannel().getId(), ""});
                    this.server.routes().apply((Object)event);
                    if (event.chunk().isLastChunk()) {
                        this.validateLastChunk(event);
                    }
                    break block14;
                }
                if (!(object instanceof WebSocketFrame)) break block16;
                WebSocketFrame x4 = (WebSocketFrame)object;
                WebSocketFrameEvent event = new WebSocketFrameEvent(e.getChannel(), (InitialHttpRequestMessage)this.initialHttpRequest().get(), x4, this.wsConfig());
                this.log().debug("WS {} CHANNEL={} {}", new Object[]{event.endPoint(), e.getChannel().getId(), ""});
                if (x4 instanceof CloseWebSocketFrame) {
                    this.wsHandshaker().close(e.getChannel(), (CloseWebSocketFrame)x4);
                } else if (x4 instanceof PingWebSocketFrame) {
                    e.getChannel().write((Object)new PongWebSocketFrame(x4.getBinaryData()));
                } else {
                    this.server.routes().apply((Object)event);
                }
            }
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)e.getMessage().getClass().toString()).append((Object)" not supported").toString());
    }

    private void validateFirstChunk(HttpRequestEvent event) {
        if (this.isAggreatingChunks(event.channel())) {
            if (event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New chunk started before the previous chunk ended");
            }
            if (!event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New request received before the previous chunk ended");
            }
        } else if (event.request().isChunked()) {
            throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
        }
    }

    private void validateLastChunk(HttpChunkEvent event) {
        if (this.isAggreatingChunks(event.channel())) {
            if (event.chunk().isLastChunk()) {
                this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)None$.MODULE$);
            }
            return;
        }
        throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        this.log().error("Exception caught in HttpRequestHandler", e.getCause());
        Throwable throwable = e.getCause();
        if (throwable instanceof MatchError) {
            MatchError x2 = (MatchError)throwable;
            this.writeErrorResponse(ctx, HttpResponseStatus.NOT_FOUND, (Throwable)x2);
        } else if (throwable instanceof TooLongFrameException) {
            TooLongFrameException x3 = (TooLongFrameException)throwable;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)x3);
        } else if (throwable instanceof UnsupportedOperationException) {
            UnsupportedOperationException x4 = (UnsupportedOperationException)throwable;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, x4);
        } else if (throwable instanceof WebSocketHandshakeException) {
            WebSocketHandshakeException x5 = (WebSocketHandshakeException)throwable;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)x5);
        } else {
            this.liftedTree1$1(e, throwable);
        }
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable ex) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");
        Predef$ predef$ = Predef$.MODULE$;
        new StringOps("Failure: %s\n\n%s\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.toString(), ex == null ? "" : ex.getMessage(), sf.format(Calendar.getInstance().getTime())}));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)new StringBuilder().append((Object)"Failure: ").append((Object)status.toString()).append((Object)"\r\n\r\n").append((Object)ex.getMessage()).append((Object)"\r\n").toString(), (Charset)CharsetUtil.UTF_8));
        Channel ch = ctx.getChannel();
        if (ch.isConnected()) {
            ch.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.server.allChannels().add(e.getChannel());
    }

    private String createWebSocketLocation(WebSocketHandshakeEvent ctx) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSSLConnection(ctx.channel()) ? "wss" : "ws");
        sb.append("://");
        sb.append((Object)ctx.request().headers().get((Object)"Host"));
        sb.append(ctx.endPoint().uri());
        return sb.toString();
    }

    private void doWebSocketHandshake(WebSocketHandshakeEvent event) {
        if (event.isAuthorized()) {
            String string = event.authorizedSubprotocols();
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.createWebSocketLocation(event), !(string != null ? !string.equals("") : "" != null) ? null : event.authorizedSubprotocols(), false, (long)event.maxFrameSize());
            this.wsHandshaker_$eq(wsFactory.newHandshaker(event.nettyHttpRequest()));
            if (this.wsHandshaker() == null) {
                wsFactory.sendUnsupportedWebSocketVersionResponse(event.channel());
                event.writeWebLog(HttpResponseStatus.UPGRADE_REQUIRED.getCode(), 0L);
            } else {
                ChannelFuture future = this.wsHandshaker().handshake(event.channel(), event.nettyHttpRequest());
                event.writeWebLog(HttpResponseStatus.SWITCHING_PROTOCOLS.getCode(), 0L);
                if (event.onComplete().isDefined()) {
                    public class Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1
                    implements ChannelFutureListener {
                        public final /* synthetic */ RequestHandler $outer;
                        private final WebSocketHandshakeEvent event$1;

                        public void operationComplete(ChannelFuture future) {
                            ((Function1)this.event$1.onComplete().get()).apply((Object)this.event$1);
                        }

                        public /* synthetic */ RequestHandler org$mashupbots$socko$webserver$RequestHandler$OnCompleteListender$$$outer() {
                            return this.$outer;
                        }

                        public Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(RequestHandler $outer, WebSocketHandshakeEvent event$1) {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.event$1 = event$1;
                        }
                    }
                    future.addListener((ChannelFutureListener)new Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(this, event));
                }
            }
            return;
        }
        throw new UnsupportedOperationException("Websocket not supported at this end point");
    }

    private boolean isSSLConnection(Channel channel) {
        return channel.getPipeline().get(SslHandler.class) != null;
    }

    private boolean isAggreatingChunks(Channel channel) {
        return channel.getPipeline().get(HttpChunkAggregator.class) != null;
    }

    private final void liftedTree1$1(ExceptionEvent e$1, Throwable x1$1) {
        try {
            this.log().debug("Error handling request", x1$1);
            e$1.getChannel().close();
        }
        catch (Throwable throwable) {
            this.log().debug("Error closing channel", throwable);
        }
    }

    public RequestHandler(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
        this.wsHandshaker = null;
        this.initialHttpRequest = None$.MODULE$;
        this.httpConfig = new HttpEventConfig(server.config().serverName(), server.config().http().minCompressibleContentSizeInBytes(), server.config().http().maxCompressibleContentSizeInBytes(), server.config().http().compressibleContentTypes(), server.webLogWriter());
    }
}

