/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.PipelineFactory;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebLogConfig;
import org.mashupbots.socko.webserver.WebServer$;
import org.mashupbots.socko.webserver.WebServerConfig;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u0001-\u0011\u0011bV3c'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011!C<fEN,'O^3s\u0015\t)a!A\u0003t_\u000e\\wN\u0003\u0002\b\u0011\u0005QQ.Y:ikB\u0014w\u000e^:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bCA\u000b\u0019\u001b\u00051\"BA\f\u0005\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!!\u0007\f\u0003\r1{wmZ3s\u0011!Y\u0002A!b\u0001\n\u0003a\u0012AB2p]\u001aLw-F\u0001\u001e!\tqr$D\u0001\u0003\u0013\t\u0001#AA\bXK\n\u001cVM\u001d<fe\u000e{gNZ5h\u0011!\u0011\u0003A!A!\u0002\u0013i\u0012aB2p]\u001aLw\r\t\u0005\tI\u0001\u0011)\u0019!C\u0001K\u00051!o\\;uKN,\u0012A\n\t\u0005O)b#'D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007CA\u00171\u001b\u0005q#BA\u0018\u0005\u0003\u0019)g/\u001a8ug&\u0011\u0011G\f\u0002\u000b'>\u001c7n\\#wK:$\bCA\u00144\u0013\t!\u0004F\u0001\u0003V]&$\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\u0002\u000fI|W\u000f^3tA!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011(A\u0006bGR|'oU=ti\u0016lW#\u0001\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014!B1di>\u0014(\"A \u0002\t\u0005\\7.Y\u0005\u0003\u0003r\u00121\"Q2u_J\u001c\u0016p\u001d;f[\"A1\t\u0001B\u0001B\u0003%!(\u0001\u0007bGR|'oU=ti\u0016l\u0007\u0005C\u0003F\u0001\u0011\u0005a)\u0001\u0004=S:LGO\u0010\u000b\u0005\u000f\"K%\n\u0005\u0002\u001f\u0001!)1\u0004\u0012a\u0001;!)A\u0005\u0012a\u0001M!)\u0001\b\u0012a\u0001u!9A\n\u0001b\u0001\n\u0003i\u0015aC1mY\u000eC\u0017M\u001c8fYN,\u0012A\u0014\t\u0003\u001fbk\u0011\u0001\u0015\u0006\u0003#J\u000bQa\u001a:pkBT!a\u0015+\u0002\u000f\rD\u0017M\u001c8fY*\u0011QKV\u0001\u0006]\u0016$H/\u001f\u0006\u0003/\"\tQA\u001b2pgNL!!\u0017)\u0003'\u0011+g-Y;mi\u000eC\u0017M\u001c8fY\u001e\u0013x.\u001e9\t\rm\u0003\u0001\u0015!\u0003O\u00031\tG\u000e\\\"iC:tW\r\\:!\u0011\u001di\u0006\u00011A\u0005\ny\u000bab\u00195b]:,GNR1di>\u0014\u00180F\u0001`!\t\u0001W-D\u0001b\u0015\t\u00117-A\u0002oS>T!\u0001\u001a*\u0002\rM|7m[3u\u0013\t1\u0017MA\u000fOS>\u001cVM\u001d<feN{7m[3u\u0007\"\fgN\\3m\r\u0006\u001cGo\u001c:z\u0011\u001dA\u0007\u00011A\u0005\n%\f!c\u00195b]:,GNR1di>\u0014\u0018p\u0018\u0013fcR\u0011!G\u001b\u0005\bW\u001e\f\t\u00111\u0001`\u0003\rAH%\r\u0005\u0007[\u0002\u0001\u000b\u0015B0\u0002\u001f\rD\u0017M\u001c8fY\u001a\u000b7\r^8ss\u0002Bqa\u001c\u0001C\u0002\u0013\u0005\u0001/\u0001\u0006tg2l\u0015M\\1hKJ,\u0012!\u001d\t\u0004OI$\u0018BA:)\u0005\u0019y\u0005\u000f^5p]B\u0011a$^\u0005\u0003m\n\u0011!bU:m\u001b\u0006t\u0017mZ3s\u0011\u0019A\b\u0001)A\u0005c\u0006Y1o\u001d7NC:\fw-\u001a:!\u0011\u001dQ\bA1A\u0005\u0002m\fAb^3c\u0019><wK]5uKJ,\u0012\u0001 \t\u0004OIl\bCA\u001e\u007f\u0013\tyHH\u0001\u0005BGR|'OU3g\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nq\fQb^3c\u0019><wK]5uKJ\u0004\u0003bBA\u0004\u0001\u0011\u0005\u0011\u0011B\u0001\u0006gR\f'\u000f\u001e\u000b\u0002e!9\u0011Q\u0002\u0001\u0005\u0002\u0005%\u0011\u0001B:u_B\u0004")
public class WebServer
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServerConfig config;
    private final PartialFunction<SockoEvent, BoxedUnit> routes;
    private final ActorSystem actorSystem;
    private final DefaultChannelGroup allChannels;
    private NioServerSocketChannelFactory channelFactory;
    private final Option<SslManager> sslManager;
    private final Option<ActorRef> webLogWriter;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        WebServer webServer = this;
        synchronized (webServer) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public WebServerConfig config() {
        return this.config;
    }

    public PartialFunction<SockoEvent, BoxedUnit> routes() {
        return this.routes;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    private NioServerSocketChannelFactory channelFactory() {
        return this.channelFactory;
    }

    private void channelFactory_$eq(NioServerSocketChannelFactory x$1) {
        this.channelFactory = x$1;
    }

    public Option<SslManager> sslManager() {
        return this.sslManager;
    }

    public Option<ActorRef> webLogWriter() {
        return this.webLogWriter;
    }

    public void start() {
        if (this.channelFactory() == null) {
            this.allChannels().clear();
            this.channelFactory_$eq(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
            ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.channelFactory());
            bootstrap.setOption("child.tcpNoDelay", this.config().tcp().noDelay().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }));
            if (this.config().tcp().sendBufferSize().isDefined()) {
                bootstrap.setOption("child.sendBufferSize", this.config().tcp().sendBufferSize().get());
            }
            if (this.config().tcp().receiveBufferSize().isDefined()) {
                bootstrap.setOption("child.receiveBufferSize", this.config().tcp().receiveBufferSize().get());
                bootstrap.setOption("child.receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1024));
            }
            if (this.config().tcp().keepAlive().isDefined()) {
                bootstrap.setOption("child.keepAlive", this.config().tcp().keepAlive().get());
            }
            if (this.config().tcp().soLinger().isDefined()) {
                bootstrap.setOption("child.soLinger", this.config().tcp().soLinger().get());
            }
            if (this.config().tcp().trafficClass().isDefined()) {
                bootstrap.setOption("child.trafficClass", this.config().tcp().trafficClass().get());
            }
            if (this.config().tcp().reuseAddress().isDefined()) {
                bootstrap.setOption("child.reuseAddress", this.config().tcp().reuseAddress().get());
            }
            if (this.config().tcp().acceptBackLog().isDefined()) {
                bootstrap.setOption("child.backlog", this.config().tcp().acceptBackLog().get());
            }
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
            Predef$.MODULE$.refArrayOps((Object[])this.config().hostname().split(",")).foreach((Function1)new Serializable(this, bootstrap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WebServer $outer;
                private final ServerBootstrap bootstrap$1;

                public final Object apply(String address) {
                    Object object;
                    String string;
                    String string2 = string = address.trim();
                    if (!("0.0.0.0" != null ? !"0.0.0.0".equals(string2) : string2 != null)) {
                        String x2 = string;
                        object = BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(this.$outer.config().port()))));
                    } else {
                        object = address.isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(address, this.$outer.config().port()))));
                    }
                    return object;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bootstrap$1 = bootstrap$1;
                }
            });
            this.log().info("Socko server '{}' started on {}:{}", new Object[]{Predef$.MODULE$.refArrayOps(new Object[]{this.config().serverName(), this.config().hostname(), ((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString()}).toArray(ClassTag$.MODULE$.AnyRef())});
            return;
        }
        this.log().info("Socko server '{}' already started", new Object[]{new String[]{this.config().serverName()}});
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels().close();
        future.awaitUninterruptibly();
        this.allChannels().clear();
        this.channelFactory().releaseExternalResources();
        this.channelFactory_$eq(null);
        this.log().info("Socko server '{}' stopped", new Object[]{this.config().serverName()});
    }

    public WebServer(WebServerConfig config, PartialFunction<SockoEvent, BoxedUnit> routes, ActorSystem actorSystem) {
        this.config = config;
        this.routes = routes;
        this.actorSystem = actorSystem;
        Logger$class.$init$(this);
        Predef$.MODULE$.require(config != null);
        config.validate();
        this.allChannels = new DefaultChannelGroup(config.serverName());
        this.channelFactory = null;
        Object object = this.sslManager = config.ssl().isEmpty() ? None$.MODULE$ : new Some((Object)new SslManager(this));
        this.webLogWriter = config.webLog().isEmpty() ? None$.MODULE$ : (((WebLogConfig)config.webLog().get()).customActorPath().isEmpty() ? new Some((Object)actorSystem.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this)))) : new Some((Object)actorSystem.actorFor((String)((WebLogConfig)config.webLog().get()).customActorPath().get())));
    }
}

