/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.netty.SpdyServerProvider;
import org.mashupbots.socko.webserver.HttpConfig;
import org.mashupbots.socko.webserver.ProtocolNegoitationHandler;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u0017\ty\u0001+\u001b9fY&tWMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001A\u0002\u0006\u0010\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\u000f\rD\u0017M\u001c8fY*\u0011\u0011DG\u0001\u0006]\u0016$H/\u001f\u0006\u00037!\tQA\u001b2pgNL!!\b\f\u0003-\rC\u0017M\u001c8fYBK\u0007/\u001a7j]\u00164\u0015m\u0019;pef\u0004\"a\b\u0012\u000e\u0003\u0001R!!\t\u0003\u0002\u001d%tgM]1tiJ,8\r^;sK&\u00111\u0005\t\u0002\u0007\u0019><w-\u001a:\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\naa]3sm\u0016\u0014\bCA\u0014)\u001b\u0005\u0011\u0011BA\u0015\u0003\u0005%9VMY*feZ,'\u000fC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"a\n\u0001\t\u000b\u0015R\u0003\u0019\u0001\u0014\t\u000bA\u0002A\u0011A\u0019\u0002\u0017\u001d,G\u000fU5qK2Lg.\u001a\u000b\u0002eA\u0011QcM\u0005\u0003iY\u0011qb\u00115b]:,G\u000eU5qK2Lg.\u001a\u0005\u0006m\u0001!I!M\u0001\u0010O\u0016$\b\n\u001e;q!&\u0004X\r\\5oK\")\u0001\b\u0001C\u0005c\u0005yq-\u001a;Ta\u0012L\b+\u001b9fY&tW\r")
public class PipelineFactory
implements ChannelPipelineFactory,
org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        PipelineFactory pipelineFactory = this;
        synchronized (pipelineFactory) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public ChannelPipeline getPipeline() {
        return this.server.config().http().spdyEnabled() ? this.getSpdyPipeline() : this.getHttpPipeline();
    }

    private ChannelPipeline getHttpPipeline() {
        ChannelPipeline newPipeline = Channels.pipeline();
        HttpConfig httpConfig = this.server.config().http();
        if (this.server.sslManager().isDefined()) {
            SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
            SslHandler ssl = new SslHandler(sslEngine);
            ssl.setCloseOnSSLException(true);
            newPipeline.addLast("ssl", (ChannelHandler)ssl);
        }
        newPipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(httpConfig.maxInitialLineLength(), httpConfig.maxHeaderSizeInBytes(), httpConfig.maxChunkSizeInBytes()));
        if (httpConfig.aggreateChunks()) {
            newPipeline.addLast("chunkAggregator", (ChannelHandler)new HttpChunkAggregator(httpConfig.maxLengthInBytes()));
        }
        newPipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        newPipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        newPipeline.addLast("handler", (ChannelHandler)new RequestHandler(this.server));
        return newPipeline;
    }

    private ChannelPipeline getSpdyPipeline() {
        ChannelPipeline newPipeline = Channels.pipeline();
        SSLEngine sslEngine = ((SslManager)this.server.sslManager().get()).createSSLEngine();
        SslHandler ssl = new SslHandler(sslEngine);
        ssl.setCloseOnSSLException(true);
        newPipeline.addLast("ssl", (ChannelHandler)ssl);
        NextProtoNego.put((SSLEngine)sslEngine, (NextProtoNego.Provider)new SpdyServerProvider());
        NextProtoNego.debug = this.log().isDebugEnabled();
        newPipeline.addLast("pipeLineSelector", (ChannelHandler)new ProtocolNegoitationHandler(this.server));
        return newPipeline;
    }

    public PipelineFactory(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
    }
}

