/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.mashupbots.socko.events.SockoEvent;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.PipelineFactory;
import org.mashupbots.socko.webserver.SslManager;
import org.mashupbots.socko.webserver.WebLogConfig;
import org.mashupbots.socko.webserver.WebServer$;
import org.mashupbots.socko.webserver.WebServerConfig;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0001\u0003\u0001-\u0011\u0011bV3c'\u0016\u0014h/\u001a:\u000b\u0005\r!\u0011!C<fEN,'O^3s\u0015\t)a!A\u0003t_\u000e\\wN\u0003\u0002\b\u0011\u0005QQ.Y:ikB\u0014w\u000e^:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u000fS:4'/Y:ueV\u001cG/\u001e:f\u0013\t9BC\u0001\u0004M_\u001e<WM\u001d\u0005\t3\u0001\u0011)\u0019!C\u00015\u000511m\u001c8gS\u001e,\u0012a\u0007\t\u00039ui\u0011AA\u0005\u0003=\t\u0011qbV3c'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0005\tA\u0001\u0011\t\u0011)A\u00057\u000591m\u001c8gS\u001e\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u000b\u0007I\u0011A\u0012\u0002\rI|W\u000f^3t+\u0005!\u0003\u0003B\u0007&O5J!A\n\b\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"\u0001K\u0016\u000e\u0003%R!A\u000b\u0003\u0002\r\u00154XM\u001c;t\u0013\ta\u0013F\u0001\u0006T_\u000e\\w.\u0012<f]R\u0004\"!\u0004\u0018\n\u0005=r!\u0001B+oSRD\u0001\"\r\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\be>,H/Z:!\u0011!\u0019\u0004A!b\u0001\n\u0003!\u0014aC1di>\u00148+_:uK6,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nQ!Y2u_JT\u0011AO\u0001\u0005C.\\\u0017-\u0003\u0002=o\tY\u0011i\u0019;peNK8\u000f^3n\u0011!q\u0004A!A!\u0002\u0013)\u0014\u0001D1di>\u00148+_:uK6\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u000f\u0001\u0011\u0015Ir\b1\u0001\u001c\u0011\u0015\u0011s\b1\u0001%\u0011\u0015\u0019t\b1\u00016\u0011\u001d9\u0005A1A\u0005\u0002!\u000b1\"\u00197m\u0007\"\fgN\\3mgV\t\u0011\n\u0005\u0002K'6\t1J\u0003\u0002M\u001b\u0006)qM]8va*\u0011ajT\u0001\bG\"\fgN\\3m\u0015\t\u0001\u0016+A\u0003oKR$\u0018P\u0003\u0002S\u0011\u0005)!NY8tg&\u0011Ak\u0013\u0002\u0014\t\u00164\u0017-\u001e7u\u0007\"\fgN\\3m\u000fJ|W\u000f\u001d\u0005\u0007-\u0002\u0001\u000b\u0011B%\u0002\u0019\u0005dGn\u00115b]:,Gn\u001d\u0011\t\u000fa\u0003\u0001\u0019!C\u00053\u0006q1\r[1o]\u0016dg)Y2u_JLX#\u0001.\u0011\u0005m\u0003W\"\u0001/\u000b\u0005us\u0016a\u00018j_*\u0011q,T\u0001\u0007g>\u001c7.\u001a;\n\u0005\u0005d&!\b(j_N+'O^3s'>\u001c7.\u001a;DQ\u0006tg.\u001a7GC\u000e$xN]=\t\u000f\r\u0004\u0001\u0019!C\u0005I\u0006\u00112\r[1o]\u0016dg)Y2u_JLx\fJ3r)\tiS\rC\u0004gE\u0006\u0005\t\u0019\u0001.\u0002\u0007a$\u0013\u0007\u0003\u0004i\u0001\u0001\u0006KAW\u0001\u0010G\"\fgN\\3m\r\u0006\u001cGo\u001c:zA!9!\u000e\u0001b\u0001\n\u0003Y\u0017AC:tY6\u000bg.Y4feV\tA\u000eE\u0002\u000e[>L!A\u001c\b\u0003\r=\u0003H/[8o!\ta\u0002/\u0003\u0002r\u0005\tQ1k\u001d7NC:\fw-\u001a:\t\rM\u0004\u0001\u0015!\u0003m\u0003-\u00198\u000f\\'b]\u0006<WM\u001d\u0011\t\u000fU\u0004!\u0019!C\u0001m\u0006aq/\u001a2M_\u001e<&/\u001b;feV\tq\u000fE\u0002\u000e[b\u0004\"AN=\n\u0005i<$\u0001C!di>\u0014(+\u001a4\t\rq\u0004\u0001\u0015!\u0003x\u000359XM\u0019'pO^\u0013\u0018\u000e^3sA!)a\u0010\u0001C\u0001\u007f\u0006)1\u000f^1siR\tQ\u0006\u0003\u0004\u0002\u0004\u0001!\ta`\u0001\u0005gR|\u0007\u000f")
public class WebServer
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServerConfig config;
    private final PartialFunction<SockoEvent, BoxedUnit> routes;
    private final ActorSystem actorSystem;
    private final DefaultChannelGroup allChannels;
    private NioServerSocketChannelFactory channelFactory;
    private final Option<SslManager> sslManager;
    private final Option<ActorRef> webLogWriter;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        WebServer webServer = this;
        synchronized (webServer) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public WebServerConfig config() {
        return this.config;
    }

    public PartialFunction<SockoEvent, BoxedUnit> routes() {
        return this.routes;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public DefaultChannelGroup allChannels() {
        return this.allChannels;
    }

    private NioServerSocketChannelFactory channelFactory() {
        return this.channelFactory;
    }

    private void channelFactory_$eq(NioServerSocketChannelFactory x$1) {
        this.channelFactory = x$1;
    }

    public Option<SslManager> sslManager() {
        return this.sslManager;
    }

    public Option<ActorRef> webLogWriter() {
        return this.webLogWriter;
    }

    public void start() {
        if (this.channelFactory() == null) {
            this.allChannels().clear();
            this.channelFactory_$eq(new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
            ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.channelFactory());
            Option<Object> option = this.config().tcp().noDelay();
            bootstrap.setOption("child.tcpNoDelay", !option.isEmpty() ? option.get() : BoxesRunTime.boxToBoolean((boolean)true));
            if (this.config().tcp().sendBufferSize().isDefined()) {
                bootstrap.setOption("child.sendBufferSize", this.config().tcp().sendBufferSize().get());
            }
            if (this.config().tcp().receiveBufferSize().isDefined()) {
                bootstrap.setOption("child.receiveBufferSize", this.config().tcp().receiveBufferSize().get());
                bootstrap.setOption("child.receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1024));
            }
            if (this.config().tcp().keepAlive().isDefined()) {
                bootstrap.setOption("child.keepAlive", this.config().tcp().keepAlive().get());
            }
            if (this.config().tcp().soLinger().isDefined()) {
                bootstrap.setOption("child.soLinger", this.config().tcp().soLinger().get());
            }
            if (this.config().tcp().trafficClass().isDefined()) {
                bootstrap.setOption("child.trafficClass", this.config().tcp().trafficClass().get());
            }
            if (this.config().tcp().reuseAddress().isDefined()) {
                bootstrap.setOption("child.reuseAddress", this.config().tcp().reuseAddress().get());
            }
            if (this.config().tcp().acceptBackLog().isDefined()) {
                bootstrap.setOption("child.backlog", this.config().tcp().acceptBackLog().get());
            }
            bootstrap.setPipelineFactory((ChannelPipelineFactory)new PipelineFactory(this));
            Object[] objectArray = this.config().hostname().split(",");
            Predef$ predef$ = Predef$.MODULE$;
            new ArrayOps.ofRef(objectArray).foreach((Function1)new Serializable(this, bootstrap){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ WebServer $outer;
                private final ServerBootstrap bootstrap$1;

                public final Object apply(String address) {
                    String string = address.trim();
                    Object object = !("0.0.0.0" != null ? !"0.0.0.0".equals(string) : string != null) ? BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(this.$outer.config().port())))) : (address.isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.$outer.allChannels().add(this.bootstrap$1.bind((SocketAddress)new InetSocketAddress(address, this.$outer.config().port())))));
                    return object;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bootstrap$1 = bootstrap$1;
                }
            });
            this.log().info("Socko server '{}' started on {}:{}", new Object[]{this.config().serverName(), this.config().hostname(), ((Object)BoxesRunTime.boxToInteger((int)this.config().port())).toString()});
            return;
        }
        this.log().info("Socko server '{}' already started", new Object[]{new String[]{this.config().serverName()}});
    }

    public void stop() {
        ChannelGroupFuture future = this.allChannels().close();
        future.awaitUninterruptibly();
        this.allChannels().clear();
        this.channelFactory().releaseExternalResources();
        this.channelFactory_$eq(null);
        this.log().info("Socko server '{}' stopped", new Object[]{this.config().serverName()});
    }

    public WebServer(WebServerConfig config, PartialFunction<SockoEvent, BoxedUnit> routes, ActorSystem actorSystem) {
        this.config = config;
        this.routes = routes;
        this.actorSystem = actorSystem;
        Logger$class.$init$(this);
        Predef$.MODULE$.require(config != null);
        config.validate();
        this.allChannels = new DefaultChannelGroup(config.serverName());
        this.channelFactory = null;
        Object object = this.sslManager = config.ssl().isEmpty() ? None$.MODULE$ : new Some((Object)new SslManager(this));
        this.webLogWriter = config.webLog().isEmpty() ? None$.MODULE$ : (((WebLogConfig)config.webLog().get()).customActorPath().isEmpty() ? new Some((Object)actorSystem.actorOf(Props$.MODULE$.apply((Function0)new $anonfun$1(this)))) : new Some((Object)actorSystem.actorFor((String)((WebLogConfig)config.webLog().get()).customActorPath().get())));
    }
}

