/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.infrastructure;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import scala.collection.mutable.StringBuilder;

public final class DateUtil$ {
    public static final DateUtil$ MODULE$;
    private final String RFC1123_DATE_FORMAT;
    private final String RFC1123_DATE_GMT_TIMEZONE;

    static {
        new DateUtil$();
    }

    public String RFC1123_DATE_FORMAT() {
        return this.RFC1123_DATE_FORMAT;
    }

    public String RFC1123_DATE_GMT_TIMEZONE() {
        return this.RFC1123_DATE_GMT_TIMEZONE;
    }

    /*
     * WARNING - void declaration
     */
    public SimpleDateFormat rfc1123DateFormatter() {
        void var1_1;
        SimpleDateFormat df = new SimpleDateFormat(this.RFC1123_DATE_FORMAT(), Locale.US);
        df.setTimeZone(TimeZone.getTimeZone(this.RFC1123_DATE_GMT_TIMEZONE()));
        return var1_1;
    }

    public Date parseISO8601Date(String s) {
        Date date;
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Null or empty string");
        }
        int n = s.length();
        switch (n) {
            default: {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot parse date: ").append((Object)s).toString());
            }
            case 28: {
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US).parse(s);
                break;
            }
            case 24: {
                if (s.endsWith("Z")) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    date = df.parse(s);
                    break;
                }
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US).parse(s);
                break;
            }
            case 23: {
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.US).parse(s);
                break;
            }
            case 20: {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = df.parse(s);
                break;
            }
            case 19: {
                date = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US).parse(s);
                break;
            }
            case 10: {
                date = new SimpleDateFormat("yyyy-MM-dd", Locale.US).parse(s);
            }
        }
        return date;
    }

    public String formatISO8601Date(Date d) {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.US).format(d);
    }

    public String formatISO8601DateTime(Date d) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US).format(d);
    }

    public String formatISO8601UTCDateTime(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df.format(d);
    }

    private DateUtil$() {
        MODULE$ = this;
        this.RFC1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
        this.RFC1123_DATE_GMT_TIMEZONE = "GMT";
    }
}

