/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.GenericFutureListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.mashupbots.socko.events.HttpChunkEvent;
import org.mashupbots.socko.events.HttpEventConfig;
import org.mashupbots.socko.events.HttpLastChunkEvent;
import org.mashupbots.socko.events.HttpRequestEvent;
import org.mashupbots.socko.events.InitialHttpRequestMessage;
import org.mashupbots.socko.events.WebSocketEventConfig;
import org.mashupbots.socko.events.WebSocketFrameEvent;
import org.mashupbots.socko.events.WebSocketHandshakeEvent;
import org.mashupbots.socko.infrastructure.CharsetUtil$;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005f\u0001B\u0001\u0003\u0001-\u0011aBU3rk\u0016\u001cH\u000fS1oI2,'O\u0003\u0002\u0004\t\u0005Iq/\u001a2tKJ4XM\u001d\u0006\u0003\u000b\u0019\tQa]8dW>T!a\u0002\u0005\u0002\u00155\f7\u000f[;qE>$8OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0006\t\u0003\u001bQi\u0011A\u0004\u0006\u0003\u001fA\tqa\u00195b]:,GN\u0003\u0002\u0012%\u0005)a.\u001a;us*\t1#\u0001\u0002j_&\u0011QC\u0004\u0002\u001d\u0007\"\fgN\\3m\u0013:\u0014w.\u001e8e\u0011\u0006tG\r\\3s\u0003\u0012\f\u0007\u000f^3s!\t9\"$D\u0001\u0019\u0015\tIB!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005mA\"A\u0002'pO\u001e,'\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u0003\u0019\u0019XM\u001d<feB\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\n/\u0016\u00147+\u001a:wKJDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtDCA\u0013'!\ty\u0002\u0001C\u0003\u001eE\u0001\u0007a\u0004C\u0004)\u0001\u0001\u0007I\u0011B\u0015\u0002\u0019]\u001c\b*\u00198eg\"\f7.\u001a:\u0016\u0003)\u0002\"a\u000b\u001b\u000e\u00031R!!\f\u0018\u0002\u0015],'m]8dW\u0016$\bP\u0003\u00020a\u0005!\u0001\u000e\u001e;q\u0015\t\t$'A\u0003d_\u0012,7M\u0003\u00024!\u00059\u0001.\u00198eY\u0016\u0014\u0018BA\u001b-\u0005e9VMY*pG.,GoU3sm\u0016\u0014\b*\u00198eg\"\f7.\u001a:\t\u000f]\u0002\u0001\u0019!C\u0005q\u0005\u0001ro\u001d%b]\u0012\u001c\b.Y6fe~#S-\u001d\u000b\u0003s}\u0002\"AO\u001f\u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012A!\u00168ji\"9\u0001INA\u0001\u0002\u0004Q\u0013a\u0001=%c!1!\t\u0001Q!\n)\nQb^:IC:$7\u000f[1lKJ\u0004\u0003b\u0002#\u0001\u0001\u0004%I!R\u0001\u0013S:LG/[1m\u0011R$\bOU3rk\u0016\u001cH/F\u0001G!\rQt)S\u0005\u0003\u0011n\u0012aa\u00149uS>t\u0007C\u0001&N\u001b\u0005Y%B\u0001'\u0005\u0003\u0019)g/\u001a8ug&\u0011aj\u0013\u0002\u001a\u0013:LG/[1m\u0011R$\bOU3rk\u0016\u001cH/T3tg\u0006<W\rC\u0004Q\u0001\u0001\u0007I\u0011B)\u0002-%t\u0017\u000e^5bY\"#H\u000f\u001d*fcV,7\u000f^0%KF$\"!\u000f*\t\u000f\u0001{\u0015\u0011!a\u0001\r\"1A\u000b\u0001Q!\n\u0019\u000b1#\u001b8ji&\fG\u000e\u0013;uaJ+\u0017/^3ti\u0002BqA\u0016\u0001C\u0002\u0013%q+\u0001\u0006iiR\u00048i\u001c8gS\u001e,\u0012\u0001\u0017\t\u0003\u0015fK!AW&\u0003\u001f!#H\u000f]#wK:$8i\u001c8gS\u001eDa\u0001\u0018\u0001!\u0002\u0013A\u0016a\u00035uiB\u001cuN\u001c4jO\u0002B\u0001B\u0018\u0001\t\u0006\u0004%IaX\u0001\toN\u001cuN\u001c4jOV\t\u0001\r\u0005\u0002KC&\u0011!m\u0013\u0002\u0015/\u0016\u00147k\\2lKR,e/\u001a8u\u0007>tg-[4\t\u0011\u0011\u0004\u0001\u0012!Q!\n\u0001\f\u0011b^:D_:4\u0017n\u001a\u0011\t\u000b\u0019\u0004A\u0011I4\u0002%U\u001cXM]#wK:$HK]5hO\u0016\u0014X\r\u001a\u000b\u0004s!l\u0007\"B5f\u0001\u0004Q\u0017aA2uqB\u0011Qb[\u0005\u0003Y:\u0011Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0003oK\u0002\u0007q.A\u0002fmR\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\t1\fgn\u001a\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018O\u0001\u0004PE*,7\r\u001e\u0005\u0006q\u0002!\t%_\u0001\fG\"\fgN\\3m%\u0016\fG\rF\u0002:unDQ![<A\u0002)DQ\u0001`<A\u0002u\f\u0011!\u001a\t\u0003uyL!a`\u001e\u0003\r\u0005s\u0017PU3g\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000b\t!C^1mS\u0012\fG/\u001a$jeN$8\t[;oWR\u0019\u0011(a\u0002\t\u0011\u0005%\u0011\u0011\u0001a\u0001\u0003\u0017\tQ!\u001a<f]R\u00042ASA\u0007\u0013\r\tya\u0013\u0002\u0011\u0011R$\bOU3rk\u0016\u001cH/\u0012<f]RDq!a\u0005\u0001\t\u0013\t)\"A\twC2LG-\u0019;f\u0019\u0006\u001cHo\u00115v].$2!OA\f\u0011!\tI!!\u0005A\u0002\u0005e\u0001c\u0001&\u0002\u001c%\u0019\u0011QD&\u0003%!#H\u000f\u001d'bgR\u001c\u0005.\u001e8l\u000bZ,g\u000e\u001e\u0005\b\u0003C\u0001A\u0011IA\u0012\u0003=)\u0007pY3qi&|gnQ1vO\"$H#B\u001d\u0002&\u0005\u001d\u0002BB5\u0002 \u0001\u0007!\u000eC\u0004}\u0003?\u0001\r!!\u000b\u0011\t\u0005-\u00121\b\b\u0005\u0003[\t9D\u0004\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019DC\u0001\u0007yI|w\u000e\u001e \n\u0003qJ1!!\u000f<\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003sY\u0004bBA\"\u0001\u0011%\u0011QI\u0001\u0013oJLG/Z#se>\u0014(+Z:q_:\u001cX\rF\u0004:\u0003\u000f\nI%!\u0016\t\r%\f\t\u00051\u0001k\u0011!\tY%!\u0011A\u0002\u00055\u0013AB:uCR,8\u000f\u0005\u0003\u0002P\u0005ES\"\u0001\u0018\n\u0007\u0005McF\u0001\nIiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\b\u0002CA,\u0003\u0003\u0002\r!!\u000b\u0002\u0005\u0015D\bbBA.\u0001\u0011\u0005\u0013QL\u0001\u000eG\"\fgN\\3m\u0003\u000e$\u0018N^3\u0015\u0007e\ny\u0006\u0003\u0004j\u00033\u0002\rA\u001b\u0005\b\u0003G\u0002A\u0011BA3\u0003]\u0019'/Z1uK^+'mU8dW\u0016$Hj\\2bi&|g\u000e\u0006\u0003\u0002h\u0005U\u0004\u0003BA5\u0003_r1AOA6\u0013\r\tigO\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u000554\bC\u0004}\u0003C\u0002\r!a\u001e\u0011\u0007)\u000bI(C\u0002\u0002|-\u0013qcV3c'>\u001c7.\u001a;IC:$7\u000f[1lK\u00163XM\u001c;\t\u000f\u0005}\u0004\u0001\"\u0003\u0002\u0002\u0006!Bm\\,fEN{7m[3u\u0011\u0006tGm\u001d5bW\u0016$2!OAB\u0011!\tI!! A\u0002\u0005]\u0004bBAD\u0001\u0011%\u0011\u0011R\u0001\u0010SN\u001c6\u000bT\"p]:,7\r^5p]R!\u00111RAI!\rQ\u0014QR\u0005\u0004\u0003\u001f[$a\u0002\"p_2,\u0017M\u001c\u0005\b\u001f\u0005\u0015\u0005\u0019AAJ!\ri\u0011QS\u0005\u0004\u0003/s!aB\"iC:tW\r\u001c\u0005\b\u00037\u0003A\u0011BAO\u0003II7/Q4he\u0016\fG/\u001b8h\u0007\",hn[:\u0015\t\u0005-\u0015q\u0014\u0005\b\u001f\u0005e\u0005\u0019AAJ\u0001")
public class RequestHandler
extends ChannelInboundHandlerAdapter
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private WebSocketServerHandshaker wsHandshaker;
    private Option<InitialHttpRequestMessage> initialHttpRequest;
    private final HttpEventConfig httpConfig;
    private WebSocketEventConfig wsConfig;
    private final Logger log;
    private volatile byte bitmap$0;

    private WebSocketEventConfig wsConfig$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.wsConfig = new WebSocketEventConfig(this.server.config().serverName(), this.server.webLogWriter());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.wsConfig;
        }
    }

    private Logger log$lzycompute() {
        RequestHandler requestHandler = this;
        synchronized (requestHandler) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.log$lzycompute() : this.log;
    }

    private WebSocketServerHandshaker wsHandshaker() {
        return this.wsHandshaker;
    }

    private void wsHandshaker_$eq(WebSocketServerHandshaker x$1) {
        this.wsHandshaker = x$1;
    }

    private Option<InitialHttpRequestMessage> initialHttpRequest() {
        return this.initialHttpRequest;
    }

    private void initialHttpRequest_$eq(Option<InitialHttpRequestMessage> x$1) {
        this.initialHttpRequest = x$1;
    }

    private HttpEventConfig httpConfig() {
        return this.httpConfig;
    }

    private WebSocketEventConfig wsConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.wsConfig$lzycompute() : this.wsConfig;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            IdleState idleState = idleStateEvent.state();
            if (!(idleState != null ? !idleState.equals(IdleState.ALL_IDLE) : IdleState.ALL_IDLE != null)) {
                ctx.close();
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object e) {
        block14: {
            block10: {
                block13: {
                    block12: {
                        block11: {
                            block9: {
                                if (!(e instanceof FullHttpRequest)) break block9;
                                FullHttpRequest fullHttpRequest = (FullHttpRequest)e;
                                HttpRequestEvent event = new HttpRequestEvent(ctx, (HttpRequest)fullHttpRequest, this.httpConfig());
                                this.log().debug("HTTP FULL REQUEST {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                                if (event.request().isWebSocketUpgrade()) {
                                    WebSocketHandshakeEvent wsctx = new WebSocketHandshakeEvent(ctx, fullHttpRequest, this.httpConfig());
                                    this.server.routes().apply((Object)wsctx);
                                    this.doWebSocketHandshake(wsctx);
                                    this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                                } else {
                                    this.server.routes().apply((Object)event);
                                }
                                break block10;
                            }
                            if (!(e instanceof HttpRequest)) break block11;
                            HttpRequest httpRequest = (HttpRequest)e;
                            HttpRequestEvent event = new HttpRequestEvent(ctx, httpRequest, this.httpConfig());
                            this.log().debug("HTTP REQUEST {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                            this.validateFirstChunk(event);
                            this.server.routes().apply((Object)event);
                            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)new Some((Object)new InitialHttpRequestMessage(event.request(), event.createdOn())));
                            break block10;
                        }
                        if (!(e instanceof LastHttpContent)) break block12;
                        LastHttpContent lastHttpContent = (LastHttpContent)e;
                        HttpLastChunkEvent event = new HttpLastChunkEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), lastHttpContent, this.httpConfig());
                        this.log().debug("HTTP LAST CHUNK {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                        this.server.routes().apply((Object)event);
                        this.validateLastChunk(event);
                        break block10;
                    }
                    if (!(e instanceof HttpContent)) break block13;
                    HttpContent httpContent = (HttpContent)e;
                    HttpChunkEvent event = new HttpChunkEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), httpContent, this.httpConfig());
                    InitialHttpRequestMessage initialHttpRequestMessage = (InitialHttpRequestMessage)this.initialHttpRequest().get();
                    initialHttpRequestMessage.totalChunkContentLength_$eq(initialHttpRequestMessage.totalChunkContentLength() + (long)httpContent.content().readableBytes());
                    this.log().debug("HTTP CHUNK {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                    this.server.routes().apply((Object)event);
                    break block10;
                }
                if (!(e instanceof WebSocketFrame)) break block14;
                WebSocketFrame webSocketFrame = (WebSocketFrame)e;
                WebSocketFrameEvent event = new WebSocketFrameEvent(ctx, (InitialHttpRequestMessage)this.initialHttpRequest().get(), webSocketFrame, this.wsConfig());
                this.log().debug("WS {} CHANNEL={} {}", new Object[]{event.endPoint(), ctx.name(), ""});
                if (webSocketFrame instanceof CloseWebSocketFrame) {
                    this.wsHandshaker().close(ctx.channel(), (CloseWebSocketFrame)webSocketFrame);
                } else if (webSocketFrame instanceof PingWebSocketFrame) {
                    ctx.writeAndFlush((Object)new PongWebSocketFrame(webSocketFrame.content()));
                } else {
                    this.server.routes().apply((Object)event);
                }
            }
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)e.getClass().toString()).append((Object)" not supported").toString());
    }

    private void validateFirstChunk(HttpRequestEvent event) {
        if (this.isAggreatingChunks(event.context().channel())) {
            if (event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New chunk started before the previous chunk ended");
            }
            if (!event.request().isChunked() && this.initialHttpRequest().isDefined()) {
                throw new IllegalStateException("New request received before the previous chunk ended");
            }
        } else if (event.request().isChunked()) {
            throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
        }
    }

    private void validateLastChunk(HttpLastChunkEvent event) {
        if (this.isAggreatingChunks(event.context().channel())) {
            this.initialHttpRequest_$eq((Option<InitialHttpRequestMessage>)None$.MODULE$);
            return;
        }
        throw new IllegalStateException("Received a chunk when chunks should have been aggreated");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        this.log().error("Exception caught in HttpRequestHandler", e);
        if (e instanceof MatchError) {
            MatchError matchError = (MatchError)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.NOT_FOUND, (Throwable)matchError);
        } else if (e instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)tooLongFrameException);
        } else if (e instanceof UnsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException = (UnsupportedOperationException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, unsupportedOperationException);
        } else if (e instanceof WebSocketHandshakeException) {
            WebSocketHandshakeException webSocketHandshakeException = (WebSocketHandshakeException)e;
            this.writeErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, (Throwable)webSocketHandshakeException);
        } else {
            try {
                this.log().debug("Error handling request", e);
                ctx.channel().close();
            }
            catch (Throwable throwable) {
                this.log().debug("Error closing channel", throwable);
            }
        }
    }

    private void writeErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, Throwable ex) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S Z");
        Predef$ predef$ = Predef$.MODULE$;
        new StringOps("Failure: %s\n\n%s\n\n%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.toString(), ex == null ? "" : ex.getMessage(), sf.format(Calendar.getInstance().getTime())}));
        byte[] bytes = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failure: ", "\\r\\n\\r\\n", "\\r\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status, ex.getMessage()})).getBytes(CharsetUtil$.MODULE$.UTF_8());
        ByteBuf content = ctx.channel().alloc().buffer(bytes.length).writeBytes(bytes);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.server.allChannels().add(ctx.channel());
    }

    private String createWebSocketLocation(WebSocketHandshakeEvent e) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.isSSLConnection(e.context().channel()) ? "wss" : "ws");
        sb.append("://");
        sb.append(e.request().headers().get("Host"));
        sb.append(e.endPoint().uri());
        return sb.toString();
    }

    private void doWebSocketHandshake(WebSocketHandshakeEvent event) {
        if (event.isAuthorized()) {
            String string = event.authorizedSubprotocols();
            WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.createWebSocketLocation(event), !(string != null ? !string.equals("") : "" != null) ? null : event.authorizedSubprotocols(), false, event.maxFrameSize());
            this.wsHandshaker_$eq(wsFactory.newHandshaker((HttpRequest)event.nettyHttpRequest()));
            if (this.wsHandshaker() == null) {
                WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)event.context().channel());
                event.writeWebLog(HttpResponseStatus.UPGRADE_REQUIRED.code(), 0L);
            } else {
                String id = event.webSocketId();
                ChannelFuture future = this.wsHandshaker().handshake(event.context().channel(), event.nettyHttpRequest());
                event.writeWebLog(HttpResponseStatus.SWITCHING_PROTOCOLS.code(), 0L);
                this.server.webSocketConnections().add(event.context().channel());
                public class Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1
                implements ChannelFutureListener {
                    public final /* synthetic */ RequestHandler $outer;
                    private final WebSocketHandshakeEvent event$1;
                    private final String id$1;

                    public void operationComplete(ChannelFuture future) {
                        ((Function1)this.event$1.onComplete().get()).apply((Object)this.id$1);
                    }

                    public /* synthetic */ RequestHandler org$mashupbots$socko$webserver$RequestHandler$OnCompleteListender$$$outer() {
                        return this.$outer;
                    }

                    public Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(RequestHandler $outer, WebSocketHandshakeEvent event$1, String id$1) {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.event$1 = event$1;
                        this.id$1 = id$1;
                    }
                }
                Object object = event.onComplete().isDefined() ? future.addListener((GenericFutureListener)new Org_mashupbots_socko_webserver_RequestHandler$OnCompleteListender$1(this, event, id)) : BoxedUnit.UNIT;
                if (event.onClose().isDefined()) {
                    public class Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1
                    implements ChannelFutureListener {
                        public final /* synthetic */ RequestHandler $outer;
                        private final WebSocketHandshakeEvent event$1;
                        private final String id$1;

                        public void operationComplete(ChannelFuture future) {
                            ((Function1)this.event$1.onClose().get()).apply((Object)this.id$1);
                        }

                        public /* synthetic */ RequestHandler org$mashupbots$socko$webserver$RequestHandler$OnCloseListender$$$outer() {
                            return this.$outer;
                        }

                        public Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1(RequestHandler $outer, WebSocketHandshakeEvent event$1, String id$1) {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.event$1 = event$1;
                            this.id$1 = id$1;
                        }
                    }
                    event.context().channel().closeFuture().addListener((GenericFutureListener)new Org_mashupbots_socko_webserver_RequestHandler$OnCloseListender$1(this, event, id));
                }
            }
            return;
        }
        throw new UnsupportedOperationException("Websocket not supported at this end point");
    }

    private boolean isSSLConnection(Channel channel) {
        return channel.pipeline().get(SslHandler.class) != null;
    }

    private boolean isAggreatingChunks(Channel channel) {
        return channel.pipeline().get(HttpObjectAggregator.class) != null;
    }

    public RequestHandler(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
        this.wsHandshaker = null;
        this.initialHttpRequest = None$.MODULE$;
        this.httpConfig = new HttpEventConfig(server.config().serverName(), server.config().http().minCompressibleContentSizeInBytes(), server.config().http().maxCompressibleContentSizeInBytes(), server.config().http().compressibleContentTypes(), server.webLogWriter());
    }
}

