/*
 * Decompiled with CFR 0.152.
 */
package org.mashupbots.socko.webserver;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.spdy.SpdyFrameDecoder;
import io.netty.handler.codec.spdy.SpdyFrameEncoder;
import io.netty.handler.codec.spdy.SpdyHttpDecoder;
import io.netty.handler.codec.spdy.SpdyHttpEncoder;
import io.netty.handler.codec.spdy.SpdyHttpResponseStreamIdHandler;
import io.netty.handler.codec.spdy.SpdySessionHandler;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.npn.NextProtoNego;
import org.mashupbots.socko.infrastructure.Logger$class;
import org.mashupbots.socko.netty.SpdyServerProvider;
import org.mashupbots.socko.webserver.HttpConfig;
import org.mashupbots.socko.webserver.RequestHandler;
import org.mashupbots.socko.webserver.WebServer;
import org.slf4j.Logger;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u0017\tQ\u0002K]8u_\u000e|GNT3h_&$\u0018\r^5p]\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\no\u0016\u00147/\u001a:wKJT!!\u0002\u0004\u0002\u000bM|7m[8\u000b\u0005\u001dA\u0011AC7bg\",\bOY8ug*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019a\u0001\"!\u0004\f\u000e\u00039Q!a\u0004\t\u0002\u000b\r|G-Z2\u000b\u0005E\u0011\u0012a\u00025b]\u0012dWM\u001d\u0006\u0003'Q\tQA\\3uifT\u0011!F\u0001\u0003S>L!a\u0006\b\u0003)\tKH/\u001a+p\u001b\u0016\u001c8/Y4f\t\u0016\u001cw\u000eZ3s!\tIB$D\u0001\u001b\u0015\tYB!\u0001\bj]\u001a\u0014\u0018m\u001d;sk\u000e$XO]3\n\u0005uQ\"A\u0002'pO\u001e,'\u000f\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003!\u0003\u0019\u0019XM\u001d<feB\u0011\u0011EI\u0007\u0002\u0005%\u00111E\u0001\u0002\n/\u0016\u00147+\u001a:wKJDQ!\n\u0001\u0005\u0002\u0019\na\u0001P5oSRtDCA\u0014)!\t\t\u0003\u0001C\u0003 I\u0001\u0007\u0001\u0005C\u0003+\u0001\u0011\u00053&\u0001\u0004eK\u000e|G-\u001a\u000b\u0005YIR$\t\u0005\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\tdF\u0001\u0003V]&$\b\"B\u001a*\u0001\u0004!\u0014aA2uqB\u0011Q\u0007O\u0007\u0002m)\u0011qGE\u0001\bG\"\fgN\\3m\u0013\tIdGA\u000bDQ\u0006tg.\u001a7IC:$G.\u001a:D_:$X\r\u001f;\t\u000bmJ\u0003\u0019\u0001\u001f\u0002\u0005%t\u0007CA\u001fA\u001b\u0005q$BA \u0013\u0003\u0019\u0011WO\u001a4fe&\u0011\u0011I\u0010\u0002\b\u0005f$XMQ;g\u0011\u0015\u0019\u0015\u00061\u0001E\u0003\ryW\u000f\u001e\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001B;uS2T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n!A*[:u!\ti\u0005+D\u0001O\u0015\ty\u0005*\u0001\u0003mC:<\u0017BA)O\u0005\u0019y%M[3di\")1\u000b\u0001C\u0005)\u0006y\u0011\r\u001a3Ta\u0012L\b*\u00198eY\u0016\u00148\u000fF\u0002V1f\u0003\"!\u000e,\n\u0005]3$aD\"iC:tW\r\u001c)ja\u0016d\u0017N\\3\t\u000bM\u0012\u0006\u0019\u0001\u001b\t\u000bi\u0013\u0006\u0019A.\u0002\u0017M\u0004H-\u001f,feNLwN\u001c\t\u00039~k\u0011!\u0018\u0006\u0003=:\tAa\u001d9es&\u0011\u0001-\u0018\u0002\f'B$\u0017PV3sg&|g\u000eC\u0003c\u0001\u0011%1-A\bbI\u0012DE\u000f\u001e9IC:$G.\u001a:t)\t)F\rC\u00034C\u0002\u0007A\u0007C\u0003g\u0001\u0011\u0005q-\u0001\u0007j]&$\b+\u001b9fY&tW\r\u0006\u0002iWB\u0011Q&[\u0005\u0003U:\u0012qAQ8pY\u0016\fg\u000eC\u00034K\u0002\u0007A\u0007")
public class ProtocolNegoitationHandler
extends ByteToMessageDecoder
implements org.mashupbots.socko.infrastructure.Logger {
    private final WebServer server;
    private final Logger log;
    private volatile boolean bitmap$0;

    private Logger log$lzycompute() {
        ProtocolNegoitationHandler protocolNegoitationHandler = this;
        synchronized (protocolNegoitationHandler) {
            if (!this.bitmap$0) {
                this.log = Logger$class.log(this);
                this.bitmap$0 = true;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$0 ? this.log : this.log$lzycompute();
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.initPipeline(ctx)) {
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private ChannelPipeline addSpdyHandlers(ChannelHandlerContext ctx, SpdyVersion spdyVersion) {
        ChannelPipeline pipeline = ctx.pipeline();
        HttpConfig httpConfig = this.server.config().http();
        pipeline.addLast("spdyDecoder", (ChannelHandler)new SpdyFrameDecoder(spdyVersion, httpConfig.maxChunkSizeInBytes(), httpConfig.maxHeaderSizeInBytes()));
        pipeline.addLast("spdyEncoder", (ChannelHandler)new SpdyFrameEncoder(spdyVersion));
        pipeline.addLast("spdySessionHandler", (ChannelHandler)new SpdySessionHandler(spdyVersion, true));
        pipeline.addLast("spdyHttpEncoder", (ChannelHandler)new SpdyHttpEncoder(spdyVersion));
        pipeline.addLast("spdyHttpDecoder", (ChannelHandler)new SpdyHttpDecoder(spdyVersion, httpConfig.maxLengthInBytes()));
        pipeline.addLast("spdyStreamIdHandler", (ChannelHandler)new SpdyHttpResponseStreamIdHandler());
        pipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        Object object = this.server.config().idleConnectionTimeout().toSeconds() > 0L ? pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, (int)this.server.config().idleConnectionTimeout().toSeconds())) : BoxedUnit.UNIT;
        return pipeline.addLast("handler", (ChannelHandler)new RequestHandler(this.server));
    }

    private ChannelPipeline addHttpHandlers(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        HttpConfig httpConfig = this.server.config().http();
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(httpConfig.maxInitialLineLength(), httpConfig.maxHeaderSizeInBytes(), httpConfig.maxChunkSizeInBytes()));
        Object object = httpConfig.aggreateChunks() ? pipeline.addLast("chunkAggregator", (ChannelHandler)new HttpObjectAggregator(httpConfig.maxLengthInBytes())) : BoxedUnit.UNIT;
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        Object object2 = this.server.config().idleConnectionTimeout().toSeconds() > 0L ? pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0, 0, (int)this.server.config().idleConnectionTimeout().toSeconds())) : BoxedUnit.UNIT;
        return pipeline.addLast("handler", (ChannelHandler)new RequestHandler(this.server));
    }

    public boolean initPipeline(ChannelHandlerContext ctx) {
        String selectedProtocol;
        block10: {
            boolean bl;
            block5: {
                block7: {
                    block9: {
                        block8: {
                            block6: {
                                block4: {
                                    ChannelPipeline pipeline = ctx.pipeline();
                                    SslHandler handler = (SslHandler)pipeline.get(SslHandler.class);
                                    if (handler == null) {
                                        throw new IllegalStateException("SslHandler is needed for SPDY");
                                    }
                                    SpdyServerProvider provider = (SpdyServerProvider)NextProtoNego.get((SSLEngine)handler.engine());
                                    selectedProtocol = provider.getSelectedProtocol();
                                    if (selectedProtocol != null) break block4;
                                    this.log().debug("Selected protocol unknown");
                                    bl = false;
                                    break block5;
                                }
                                this.log().debug("Selected protocol: {} ", new Object[]{selectedProtocol});
                                if ("spdy/3.1" != null ? !"spdy/3.1".equals(selectedProtocol) : selectedProtocol != null) break block6;
                                this.addSpdyHandlers(ctx, SpdyVersion.SPDY_3_1);
                                break block7;
                            }
                            if ("spdy/3" != null ? !"spdy/3".equals(selectedProtocol) : selectedProtocol != null) break block8;
                            this.addSpdyHandlers(ctx, SpdyVersion.SPDY_3);
                            break block7;
                        }
                        if ("http/1.1" != null ? !"http/1.1".equals(selectedProtocol) : selectedProtocol != null) break block9;
                        this.addHttpHandlers(ctx);
                        break block7;
                    }
                    if ("http/1.0" != null ? !"http/1.0".equals(selectedProtocol) : selectedProtocol != null) break block10;
                    this.addHttpHandlers(ctx);
                }
                bl = true;
            }
            return bl;
        }
        throw new UnsupportedOperationException(new StringBuilder().append((Object)"Unsupported protocol: ").append((Object)selectedProtocol).toString());
    }

    public ProtocolNegoitationHandler(WebServer server) {
        this.server = server;
        Logger$class.$init$(this);
    }
}

